/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class FilePackResources
extends AbstractPackResources {
    static final Logger LOGGER = LogUtils.getLogger();
    private final SharedZipFileAccess zipFileAccess;
    private final String prefix;

    FilePackResources(PackLocationInfo info, SharedZipFileAccess zipFile, String overlay) {
        super(info);
        this.zipFileAccess = zipFile;
        this.prefix = overlay;
    }

    private static String getPathFromLocation(PackType type, ResourceLocation id) {
        return String.format(Locale.ROOT, "%s/%s/%s", type.getDirectory(), id.getNamespace(), id.getPath());
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> getRootResource(String ... segments) {
        return this.getResource(String.join((CharSequence)"/", segments));
    }

    @Override
    @Override
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation id) {
        return this.getResource(FilePackResources.getPathFromLocation(type, id));
    }

    private String addPrefix(String path) {
        if (this.prefix.isEmpty()) {
            return path;
        }
        return this.prefix + "/" + path;
    }

    @Nullable
    private IoSupplier<InputStream> getResource(String path) {
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile == null) {
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(this.addPrefix(path));
        if (zipEntry == null) {
            return null;
        }
        return IoSupplier.create(zipFile, zipEntry);
    }

    @Override
    @Override
    public Set<String> getNamespaces(PackType type) {
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet set = Sets.newHashSet();
        String string = this.addPrefix(type.getDirectory() + "/");
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            String string3 = FilePackResources.extractNamespace(string, string2);
            if (string3.isEmpty()) continue;
            if (ResourceLocation.isValidNamespace(string3)) {
                set.add(string3);
                continue;
            }
            LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)string3, (Object)this.zipFileAccess.file);
        }
        return set;
    }

    @VisibleForTesting
    public static String extractNamespace(String prefix, String entryName) {
        if (!entryName.startsWith(prefix)) {
            return "";
        }
        int i = prefix.length();
        int j = entryName.indexOf(47, i);
        if (j == -1) {
            return entryName.substring(i);
        }
        return entryName.substring(i, j);
    }

    @Override
    @Override
    public void close() {
        this.zipFileAccess.close();
    }

    @Override
    @Override
    public void listResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile == null) {
            return;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        String string = this.addPrefix(type.getDirectory() + "/" + namespace + "/");
        String string2 = string + prefix + "/";
        while (enumeration.hasMoreElements()) {
            String string3;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !(string3 = zipEntry.getName()).startsWith(string2)) continue;
            String string4 = string3.substring(string.length());
            ResourceLocation resourceLocation = ResourceLocation.tryBuild(namespace, string4);
            if (resourceLocation != null) {
                consumer.accept(resourceLocation, IoSupplier.create(zipFile, zipEntry));
                continue;
            }
            LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)string4);
        }
    }

    static class SharedZipFileAccess
    implements AutoCloseable {
        final File file;
        @Nullable
        private ZipFile zipFile;
        private boolean failedToLoad;

        SharedZipFileAccess(File file) {
            this.file = file;
        }

        @Nullable
        ZipFile getOrCreateZipFile() {
            if (this.failedToLoad) {
                return null;
            }
            if (this.zipFile == null) {
                try {
                    this.zipFile = new ZipFile(this.file);
                }
                catch (IOException iOException) {
                    LOGGER.error("Failed to open pack {}", (Object)this.file, (Object)iOException);
                    this.failedToLoad = true;
                    return null;
                }
            }
            return this.zipFile;
        }

        @Override
        @Override
        public void close() {
            if (this.zipFile != null) {
                IOUtils.closeQuietly((Closeable)this.zipFile);
                this.zipFile = null;
            }
        }

        @Override
        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static class FileResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final File content;

        public FileResourcesSupplier(Path path) {
            this(path.toFile());
        }

        public FileResourcesSupplier(File file) {
            this.content = file;
        }

        @Override
        @Override
        public PackResources openPrimary(PackLocationInfo info) {
            SharedZipFileAccess sharedZipFileAccess = new SharedZipFileAccess(this.content);
            return new FilePackResources(info, sharedZipFileAccess, "");
        }

        @Override
        @Override
        public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
            SharedZipFileAccess sharedZipFileAccess = new SharedZipFileAccess(this.content);
            FilePackResources packResources = new FilePackResources(info, sharedZipFileAccess, "");
            List<String> list = metadata.overlays();
            if (list.isEmpty()) {
                return packResources;
            }
            ArrayList<PackResources> list2 = new ArrayList<PackResources>(list.size());
            for (String string : list) {
                list2.add(new FilePackResources(info, sharedZipFileAccess, string));
            }
            return new CompositePackResources(packResources, list2);
        }
    }
}

