/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.linkfs;

import com.google.common.base.Splitter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.packs.linkfs.LinkFSFileStore;
import net.minecraft.server.packs.linkfs.LinkFSPath;
import net.minecraft.server.packs.linkfs.LinkFSProvider;
import net.minecraft.server.packs.linkfs.PathContents;

public class LinkFileSystem
extends FileSystem {
    private static final Set<String> VIEWS = Set.of("basic");
    public static final String PATH_SEPARATOR = "/";
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/');
    private final FileStore store;
    private final FileSystemProvider provider = new LinkFSProvider();
    private final LinkFSPath root;

    LinkFileSystem(String name, DirectoryEntry root) {
        this.store = new LinkFSFileStore(name);
        this.root = LinkFileSystem.buildPath(root, this, "", null);
    }

    private static LinkFSPath buildPath(DirectoryEntry root, LinkFileSystem fileSystem, String name, @Nullable LinkFSPath parent) {
        Object2ObjectOpenHashMap object2ObjectOpenHashMap = new Object2ObjectOpenHashMap();
        LinkFSPath linkFSPath = new LinkFSPath(fileSystem, name, parent, new PathContents.DirectoryContents((Map<String, LinkFSPath>)object2ObjectOpenHashMap));
        root.files.forEach((fileName, path) -> object2ObjectOpenHashMap.put(fileName, (Object)new LinkFSPath(fileSystem, (String)fileName, linkFSPath, new PathContents.FileContents((Path)path))));
        root.children.forEach((directoryName, directory) -> object2ObjectOpenHashMap.put(directoryName, (Object)LinkFileSystem.buildPath(directory, fileSystem, directoryName, linkFSPath)));
        object2ObjectOpenHashMap.trim();
        return linkFSPath;
    }

    @Override
    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    @Override
    public void close() {
    }

    @Override
    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    @Override
    public String getSeparator() {
        return PATH_SEPARATOR;
    }

    @Override
    @Override
    public Iterable<Path> getRootDirectories() {
        return List.of(this.root);
    }

    @Override
    @Override
    public Iterable<FileStore> getFileStores() {
        return List.of(this.store);
    }

    @Override
    @Override
    public Set<String> supportedFileAttributeViews() {
        return VIEWS;
    }

    @Override
    @Override
    public Path getPath(String string, String ... strings) {
        String string2;
        Stream<String> stream = Stream.of(string);
        if (strings.length > 0) {
            stream = Stream.concat(stream, Stream.of(strings));
        }
        if ((string2 = stream.collect(Collectors.joining(PATH_SEPARATOR))).equals(PATH_SEPARATOR)) {
            return this.root;
        }
        if (string2.startsWith(PATH_SEPARATOR)) {
            LinkFSPath linkFSPath = this.root;
            for (String string3 : PATH_SPLITTER.split((CharSequence)string2.substring(1))) {
                if (string3.isEmpty()) {
                    throw new IllegalArgumentException("Empty paths not allowed");
                }
                linkFSPath = linkFSPath.resolveName(string3);
            }
            return linkFSPath;
        }
        LinkFSPath linkFSPath2 = null;
        for (String string4 : PATH_SPLITTER.split((CharSequence)string2)) {
            if (string4.isEmpty()) {
                throw new IllegalArgumentException("Empty paths not allowed");
            }
            linkFSPath2 = new LinkFSPath(this, string4, linkFSPath2, PathContents.RELATIVE);
        }
        if (linkFSPath2 == null) {
            throw new IllegalArgumentException("Empty paths not allowed");
        }
        return linkFSPath2;
    }

    @Override
    @Override
    public PathMatcher getPathMatcher(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    public FileStore store() {
        return this.store;
    }

    public LinkFSPath rootPath() {
        return this.root;
    }

    public static Builder builder() {
        return new Builder();
    }

    record DirectoryEntry(Map<String, DirectoryEntry> children, Map<String, Path> files) {
        public DirectoryEntry() {
            this(new HashMap<String, DirectoryEntry>(), new HashMap<String, Path>());
        }
    }

    public static class Builder {
        private final DirectoryEntry root = new DirectoryEntry();

        public Builder put(List<String> directories, String name, Path path) {
            DirectoryEntry directoryEntry = this.root;
            for (String string : directories) {
                directoryEntry = directoryEntry.children.computeIfAbsent(string, directory -> new DirectoryEntry());
            }
            directoryEntry.files.put(name, path);
            return this;
        }

        public Builder put(List<String> directories, Path path) {
            if (directories.isEmpty()) {
                throw new IllegalArgumentException("Path can't be empty");
            }
            int i = directories.size() - 1;
            return this.put(directories.subList(0, i), directories.get(i), path);
        }

        public FileSystem build(String name) {
            return new LinkFileSystem(name, this.root);
        }
    }
}

