/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;

public class FallbackResourceManager
implements ResourceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    protected final List<PackEntry> fallbacks = Lists.newArrayList();
    private final PackType type;
    private final String namespace;

    public FallbackResourceManager(PackType type, String namespace) {
        this.type = type;
        this.namespace = namespace;
    }

    public void push(PackResources pack) {
        this.pushInternal(pack.packId(), pack, null);
    }

    public void push(PackResources pack, Predicate<ResourceLocation> filter) {
        this.pushInternal(pack.packId(), pack, filter);
    }

    public void pushFilterOnly(String id, Predicate<ResourceLocation> filter) {
        this.pushInternal(id, null, filter);
    }

    private void pushInternal(String id, @Nullable PackResources underlyingPack, @Nullable Predicate<ResourceLocation> filter) {
        this.fallbacks.add(new PackEntry(id, underlyingPack, filter));
    }

    @Override
    @Override
    public Set<String> getNamespaces() {
        return ImmutableSet.of((Object)this.namespace);
    }

    @Override
    @Override
    public Optional<Resource> getResource(ResourceLocation id) {
        for (int i = this.fallbacks.size() - 1; i >= 0; --i) {
            IoSupplier<InputStream> ioSupplier;
            PackEntry packEntry = this.fallbacks.get(i);
            PackResources packResources = packEntry.resources;
            if (packResources != null && (ioSupplier = packResources.getResource(this.type, id)) != null) {
                IoSupplier<ResourceMetadata> ioSupplier2 = this.createStackMetadataFinder(id, i);
                return Optional.of(FallbackResourceManager.createResource(packResources, id, ioSupplier, ioSupplier2));
            }
            if (!packEntry.isFiltered(id)) continue;
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)id, (Object)packEntry.name);
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static Resource createResource(PackResources pack, ResourceLocation id, IoSupplier<InputStream> supplier, IoSupplier<ResourceMetadata> metadataSupplier) {
        return new Resource(pack, FallbackResourceManager.wrapForDebug(id, pack, supplier), metadataSupplier);
    }

    private static IoSupplier<InputStream> wrapForDebug(ResourceLocation id, PackResources pack, IoSupplier<InputStream> supplier) {
        if (LOGGER.isDebugEnabled()) {
            return () -> new LeakedResourceWarningInputStream((InputStream)supplier.get(), id, pack.packId());
        }
        return supplier;
    }

    @Override
    @Override
    public List<Resource> getResourceStack(ResourceLocation id) {
        ResourceLocation resourceLocation = FallbackResourceManager.getMetadataLocation(id);
        ArrayList<Resource> list = new ArrayList<Resource>();
        boolean bl = false;
        String string = null;
        for (int i = this.fallbacks.size() - 1; i >= 0; --i) {
            IoSupplier<InputStream> ioSupplier;
            PackEntry packEntry = this.fallbacks.get(i);
            PackResources packResources = packEntry.resources;
            if (packResources != null && (ioSupplier = packResources.getResource(this.type, id)) != null) {
                IoSupplier<ResourceMetadata> ioSupplier3;
                if (bl) {
                    IoSupplier<ResourceMetadata> ioSupplier2 = ResourceMetadata.EMPTY_SUPPLIER;
                } else {
                    ioSupplier3 = () -> {
                        IoSupplier<InputStream> ioSupplier = packResources.getResource(this.type, resourceLocation);
                        return ioSupplier != null ? FallbackResourceManager.parseMetadata(ioSupplier) : ResourceMetadata.EMPTY;
                    };
                }
                list.add(new Resource(packResources, ioSupplier, ioSupplier3));
            }
            if (packEntry.isFiltered(id)) {
                string = packEntry.name;
                break;
            }
            if (!packEntry.isFiltered(resourceLocation)) continue;
            bl = true;
        }
        if (list.isEmpty() && string != null) {
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)id, string);
        }
        return Lists.reverse(list);
    }

    private static boolean isMetadata(ResourceLocation id) {
        return id.getPath().endsWith(".mcmeta");
    }

    private static ResourceLocation getResourceLocationFromMetadata(ResourceLocation id) {
        String string = id.getPath().substring(0, id.getPath().length() - ".mcmeta".length());
        return id.withPath(string);
    }

    static ResourceLocation getMetadataLocation(ResourceLocation id) {
        return id.withPath(id.getPath() + ".mcmeta");
    }

    @Override
    @Override
    public Map<ResourceLocation, Resource> listResources(String startingPath, Predicate<ResourceLocation> allowedPathPredicate) {
        record ResourceWithSourceAndIndex(PackResources packResources, IoSupplier<InputStream> resource, int packIndex) {
        }
        HashMap<ResourceLocation, ResourceWithSourceAndIndex> map = new HashMap<ResourceLocation, ResourceWithSourceAndIndex>();
        HashMap map2 = new HashMap();
        int i = this.fallbacks.size();
        for (int j = 0; j < i; ++j) {
            PackEntry packEntry = this.fallbacks.get(j);
            packEntry.filterAll(map.keySet());
            packEntry.filterAll(map2.keySet());
            PackResources packResources = packEntry.resources;
            if (packResources == null) continue;
            int k = j;
            packResources.listResources(this.type, this.namespace, startingPath, (id, supplier) -> {
                if (FallbackResourceManager.isMetadata(id)) {
                    if (allowedPathPredicate.test(FallbackResourceManager.getResourceLocationFromMetadata(id))) {
                        map2.put(id, new ResourceWithSourceAndIndex(packResources, (IoSupplier<InputStream>)supplier, k));
                    }
                } else if (allowedPathPredicate.test((ResourceLocation)id)) {
                    map.put((ResourceLocation)id, new ResourceWithSourceAndIndex(packResources, (IoSupplier<InputStream>)supplier, k));
                }
            });
        }
        TreeMap map3 = Maps.newTreeMap();
        map.forEach((id, result) -> {
            IoSupplier<ResourceMetadata> ioSupplier2;
            ResourceLocation resourceLocation = FallbackResourceManager.getMetadataLocation(id);
            ResourceWithSourceAndIndex lv = (ResourceWithSourceAndIndex)map2.get(resourceLocation);
            if (lv != null && lv.packIndex >= result.packIndex) {
                IoSupplier<ResourceMetadata> ioSupplier = FallbackResourceManager.convertToMetadata(lv.resource);
            } else {
                ioSupplier2 = ResourceMetadata.EMPTY_SUPPLIER;
            }
            map3.put(id, FallbackResourceManager.createResource(result.packResources, id, result.resource, ioSupplier2));
        });
        return map3;
    }

    private IoSupplier<ResourceMetadata> createStackMetadataFinder(ResourceLocation id, int index) {
        return () -> {
            ResourceLocation resourceLocation2 = FallbackResourceManager.getMetadataLocation(id);
            for (int j = this.fallbacks.size() - 1; j >= index; --j) {
                IoSupplier<InputStream> ioSupplier;
                PackEntry packEntry = this.fallbacks.get(j);
                PackResources packResources = packEntry.resources;
                if (packResources != null && (ioSupplier = packResources.getResource(this.type, resourceLocation2)) != null) {
                    return FallbackResourceManager.parseMetadata(ioSupplier);
                }
                if (packEntry.isFiltered(resourceLocation2)) break;
            }
            return ResourceMetadata.EMPTY;
        };
    }

    private static IoSupplier<ResourceMetadata> convertToMetadata(IoSupplier<InputStream> supplier) {
        return () -> FallbackResourceManager.parseMetadata(supplier);
    }

    private static ResourceMetadata parseMetadata(IoSupplier<InputStream> supplier) throws IOException {
        try (InputStream inputStream = supplier.get();){
            ResourceMetadata resourceMetadata = ResourceMetadata.fromJsonStream(inputStream);
            return resourceMetadata;
        }
    }

    private static void applyPackFiltersToExistingResources(PackEntry pack, Map<ResourceLocation, EntryStack> idToEntryList) {
        for (EntryStack entryStack : idToEntryList.values()) {
            if (pack.isFiltered(entryStack.fileLocation)) {
                entryStack.fileSources.clear();
                continue;
            }
            if (!pack.isFiltered(entryStack.metadataLocation())) continue;
            entryStack.metaSources.clear();
        }
    }

    private void listPackResources(PackEntry pack, String startingPath, Predicate<ResourceLocation> allowedPathPredicate, Map<ResourceLocation, EntryStack> idToEntryList) {
        PackResources packResources = pack.resources;
        if (packResources == null) {
            return;
        }
        packResources.listResources(this.type, this.namespace, startingPath, (id, supplier) -> {
            if (FallbackResourceManager.isMetadata(id)) {
                ResourceLocation resourceLocation = FallbackResourceManager.getResourceLocationFromMetadata(id);
                if (!allowedPathPredicate.test(resourceLocation)) {
                    return;
                }
                map.computeIfAbsent(resourceLocation, (Function<ResourceLocation, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).metaSources.put(packResources, (IoSupplier<InputStream>)supplier);
            } else {
                if (!allowedPathPredicate.test((ResourceLocation)id)) {
                    return;
                }
                map.computeIfAbsent(id, (Function<ResourceLocation, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).fileSources.add(new ResourceWithSource(packResources, (IoSupplier<InputStream>)supplier));
            }
        });
    }

    @Override
    @Override
    public Map<ResourceLocation, List<Resource>> listResourceStacks(String startingPath, Predicate<ResourceLocation> allowedPathPredicate) {
        HashMap map = Maps.newHashMap();
        for (PackEntry packEntry : this.fallbacks) {
            FallbackResourceManager.applyPackFiltersToExistingResources(packEntry, map);
            this.listPackResources(packEntry, startingPath, allowedPathPredicate, map);
        }
        TreeMap treeMap = Maps.newTreeMap();
        for (EntryStack entryStack : map.values()) {
            if (entryStack.fileSources.isEmpty()) continue;
            ArrayList<Resource> list = new ArrayList<Resource>();
            for (ResourceWithSource resourceWithSource : entryStack.fileSources) {
                PackResources packResources = resourceWithSource.source;
                IoSupplier<InputStream> ioSupplier = entryStack.metaSources.get(packResources);
                IoSupplier<ResourceMetadata> ioSupplier2 = ioSupplier != null ? FallbackResourceManager.convertToMetadata(ioSupplier) : ResourceMetadata.EMPTY_SUPPLIER;
                list.add(FallbackResourceManager.createResource(packResources, entryStack.fileLocation, resourceWithSource.resource, ioSupplier2));
            }
            treeMap.put(entryStack.fileLocation, list);
        }
        return treeMap;
    }

    @Override
    @Override
    public Stream<PackResources> listPacks() {
        return this.fallbacks.stream().map(pack -> pack.resources).filter(Objects::nonNull);
    }

    record PackEntry(String name, @Nullable PackResources resources, @Nullable Predicate<ResourceLocation> filter) {
        public void filterAll(Collection<ResourceLocation> ids) {
            if (this.filter != null) {
                ids.removeIf(this.filter);
            }
        }

        public boolean isFiltered(ResourceLocation id) {
            return this.filter != null && this.filter.test(id);
        }
    }

    record EntryStack(ResourceLocation fileLocation, ResourceLocation metadataLocation, List<ResourceWithSource> fileSources, Map<PackResources, IoSupplier<InputStream>> metaSources) {
        EntryStack(ResourceLocation id) {
            this(id, FallbackResourceManager.getMetadataLocation(id), new ArrayList<ResourceWithSource>(), (Map<PackResources, IoSupplier<InputStream>>)new Object2ObjectArrayMap());
        }
    }

    record ResourceWithSource(PackResources source, IoSupplier<InputStream> resource) {
    }

    static class LeakedResourceWarningInputStream
    extends FilterInputStream {
        private final Supplier<String> message;
        private boolean closed;

        public LeakedResourceWarningInputStream(InputStream parent, ResourceLocation id, String packId) {
            super(parent);
            Exception exception = new Exception("Stacktrace");
            this.message = () -> {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                return "Leaked resource: '" + String.valueOf(id) + "' loaded from pack: '" + packId + "'\n" + String.valueOf(stringWriter);
            };
        }

        @Override
        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        @Override
        protected void finalize() throws Throwable {
            if (!this.closed) {
                LOGGER.warn("{}", (Object)this.message.get());
            }
            super.finalize();
        }
    }
}

