/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MCUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class GameProfileCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int GAMEPROFILES_MRU_LIMIT = 1000;
    private static final int GAMEPROFILES_EXPIRATION_MONTHS = 1;
    private static boolean usesAuthentication;
    private final Map<String, GameProfileInfo> profilesByName = Maps.newConcurrentMap();
    private final Map<UUID, GameProfileInfo> profilesByUUID = Maps.newConcurrentMap();
    private final Map<String, CompletableFuture<Optional<GameProfile>>> requests = Maps.newConcurrentMap();
    private final GameProfileRepository profileRepository;
    private final Gson gson = new GsonBuilder().create();
    private final File file;
    private final AtomicLong operationCount = new AtomicLong();
    @Nullable
    private Executor executor;
    protected final ReentrantLock stateLock = new ReentrantLock();
    protected final ReentrantLock lookupLock = new ReentrantLock();

    public GameProfileCache(GameProfileRepository profileRepository, File cacheFile) {
        this.profileRepository = profileRepository;
        this.file = cacheFile;
        Lists.reverse(this.load()).forEach(this::safeAdd);
    }

    private void safeAdd(GameProfileInfo entry) {
        try {
            this.stateLock.lock();
            GameProfile gameprofile = entry.getProfile();
            entry.setLastAccess(this.getNextOperation());
            this.profilesByName.put(gameprofile.getName().toLowerCase(Locale.ROOT), entry);
            this.profilesByUUID.put(gameprofile.getId(), entry);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static Optional<GameProfile> lookupGameProfile(GameProfileRepository repository, String name) {
        GameProfile gameprofile;
        if (!StringUtil.isValidPlayerName(name)) {
            return GameProfileCache.createUnknownProfile(name);
        }
        final AtomicReference atomicreference = new AtomicReference();
        ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile gameprofile) {
                atomicreference.set(gameprofile);
            }

            public void onProfileLookupFailed(String s1, Exception exception) {
                atomicreference.set(null);
            }
        };
        if (!StringUtils.isBlank((CharSequence)name) && GlobalConfiguration.get().proxies.isProxyOnlineMode()) {
            repository.findProfilesByNames(new String[]{name}, profilelookupcallback);
        }
        return (gameprofile = (GameProfile)atomicreference.get()) != null ? Optional.of(gameprofile) : GameProfileCache.createUnknownProfile(name);
    }

    private static Optional<GameProfile> createUnknownProfile(String name) {
        return GameProfileCache.usesAuthentication() ? Optional.empty() : Optional.of(UUIDUtil.createOfflineProfile(name));
    }

    public static void setUsesAuthentication(boolean value) {
        usesAuthentication = value;
    }

    private static boolean usesAuthentication() {
        return GlobalConfiguration.get().proxies.isProxyOnlineMode();
    }

    public void add(GameProfile profile) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date date = calendar.getTime();
        GameProfileInfo usercache_usercacheentry = new GameProfileInfo(profile, date);
        this.safeAdd(usercache_usercacheentry);
        if (!SpigotConfig.saveUserCacheOnStopOnly) {
            this.save(true);
        }
    }

    private long getNextOperation() {
        return this.operationCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GameProfile getProfileIfCached(String name) {
        try {
            this.stateLock.lock();
            GameProfileInfo entry = this.profilesByName.get(name.toLowerCase(Locale.ROOT));
            if (entry == null) {
                GameProfile gameProfile = null;
                return gameProfile;
            }
            entry.setLastAccess(this.getNextOperation());
            GameProfile gameProfile = entry.getProfile();
            return gameProfile;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GameProfile> get(String name) {
        String s1 = name.toLowerCase(Locale.ROOT);
        boolean stateLocked = true;
        try {
            Optional<GameProfile> optional;
            this.stateLock.lock();
            GameProfileInfo usercache_usercacheentry = this.profilesByName.get(s1);
            boolean flag = false;
            if (usercache_usercacheentry != null && new Date().getTime() >= usercache_usercacheentry.expirationDate.getTime()) {
                this.profilesByUUID.remove(usercache_usercacheentry.getProfile().getId());
                this.profilesByName.remove(usercache_usercacheentry.getProfile().getName().toLowerCase(Locale.ROOT));
                flag = true;
                usercache_usercacheentry = null;
            }
            if (usercache_usercacheentry != null) {
                usercache_usercacheentry.setLastAccess(this.getNextOperation());
                optional = Optional.of(usercache_usercacheentry.getProfile());
                stateLocked = false;
                this.stateLock.unlock();
            } else {
                stateLocked = false;
                this.stateLock.unlock();
                try {
                    this.lookupLock.lock();
                    optional = GameProfileCache.lookupGameProfile(this.profileRepository, name);
                }
                finally {
                    this.lookupLock.unlock();
                }
                if (optional.isPresent()) {
                    this.add(optional.get());
                    flag = false;
                }
            }
            if (flag && !SpigotConfig.saveUserCacheOnStopOnly) {
                this.save(true);
            }
            Optional<GameProfile> optional2 = optional;
            return optional2;
        }
        finally {
            if (stateLocked) {
                this.stateLock.unlock();
            }
        }
    }

    public CompletableFuture<Optional<GameProfile>> getAsync(String username) {
        if (this.executor == null) {
            throw new IllegalStateException("No executor");
        }
        CompletableFuture<Optional<GameProfile>> completablefuture = this.requests.get(username);
        if (completablefuture != null) {
            return completablefuture;
        }
        CompletionStage completablefuture1 = CompletableFuture.supplyAsync(() -> this.get(username), Util.PROFILE_EXECUTOR).whenCompleteAsync((optional, throwable) -> this.requests.remove(username), this.executor);
        this.requests.put(username, (CompletableFuture<Optional<GameProfile>>)completablefuture1);
        return completablefuture1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GameProfile> get(UUID uuid) {
        try {
            this.stateLock.lock();
            GameProfileInfo usercache_usercacheentry = this.profilesByUUID.get(uuid);
            if (usercache_usercacheentry == null) {
                Optional<GameProfile> optional = Optional.empty();
                return optional;
            }
            usercache_usercacheentry.setLastAccess(this.getNextOperation());
            Optional<GameProfile> optional = Optional.of(usercache_usercacheentry.getProfile());
            return optional;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void clearExecutor() {
        this.executor = null;
    }

    private static DateFormat createDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    }

    public List<GameProfileInfo> load() {
        ArrayList list;
        block11: {
            list = Lists.newArrayList();
            try {
                ArrayList arraylist;
                try (BufferedReader bufferedreader = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);){
                    JsonArray jsonarray = (JsonArray)this.gson.fromJson((Reader)bufferedreader, JsonArray.class);
                    if (jsonarray != null) {
                        DateFormat dateformat = GameProfileCache.createDateFormat();
                        jsonarray.forEach(jsonelement -> {
                            Optional<GameProfileInfo> optional = GameProfileCache.readGameProfile(jsonelement, dateformat);
                            Objects.requireNonNull(list);
                            optional.ifPresent(list::add);
                        });
                        break block11;
                    }
                    arraylist = list;
                }
                return arraylist;
            }
            catch (FileNotFoundException bufferedreader) {
            }
            catch (JsonSyntaxException | NullPointerException ex) {
                LOGGER.warn("Usercache.json is corrupted or has bad formatting. Deleting it to prevent further issues.");
                this.file.delete();
            }
            catch (JsonParseException | IOException ioexception) {
                LOGGER.warn("Failed to load profile cache {}", (Object)this.file, (Object)ioexception);
            }
        }
        return list;
    }

    public void save(boolean asyncSave) {
        JsonArray jsonarray = new JsonArray();
        DateFormat dateformat = GameProfileCache.createDateFormat();
        this.listTopMRUProfiles(SpigotConfig.userCacheCap).forEach(usercache_usercacheentry -> jsonarray.add(GameProfileCache.writeGameProfile(usercache_usercacheentry, dateformat)));
        String s = this.gson.toJson((JsonElement)jsonarray);
        Runnable save = () -> {
            try (BufferedWriter bufferedwriter = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
                bufferedwriter.write(s);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        if (asyncSave) {
            MCUtil.scheduleAsyncTask(save);
        } else {
            save.run();
        }
    }

    private Stream<GameProfileInfo> getTopMRUProfiles(int limit) {
        return this.listTopMRUProfiles(limit).stream();
    }

    private List<GameProfileInfo> listTopMRUProfiles(int limit) {
        try {
            this.stateLock.lock();
            List<GameProfileInfo> list = this.profilesByUUID.values().stream().sorted(Comparator.comparing(GameProfileInfo::getLastAccess).reversed()).limit(limit).toList();
            return list;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static JsonElement writeGameProfile(GameProfileInfo entry, DateFormat dateFormat) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("name", entry.getProfile().getName());
        jsonobject.addProperty("uuid", entry.getProfile().getId().toString());
        jsonobject.addProperty("expiresOn", dateFormat.format(entry.getExpirationDate()));
        return jsonobject;
    }

    private static Optional<GameProfileInfo> readGameProfile(JsonElement json, DateFormat dateFormat) {
        if (json.isJsonObject()) {
            JsonObject jsonobject = json.getAsJsonObject();
            JsonElement jsonelement1 = jsonobject.get("name");
            JsonElement jsonelement2 = jsonobject.get("uuid");
            JsonElement jsonelement3 = jsonobject.get("expiresOn");
            if (jsonelement1 != null && jsonelement2 != null) {
                String s = jsonelement2.getAsString();
                String s1 = jsonelement1.getAsString();
                Date date = null;
                if (jsonelement3 != null) {
                    try {
                        date = dateFormat.parse(jsonelement3.getAsString());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (s1 != null && s != null && date != null) {
                    UUID uuid;
                    try {
                        uuid = UUID.fromString(s);
                    }
                    catch (Throwable throwable) {
                        return Optional.empty();
                    }
                    return Optional.of(new GameProfileInfo(new GameProfile(uuid, s1), date));
                }
                return Optional.empty();
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static class GameProfileInfo {
        private final GameProfile profile;
        final Date expirationDate;
        private volatile long lastAccess;

        GameProfileInfo(GameProfile profile, Date expirationDate) {
            this.profile = profile;
            this.expirationDate = expirationDate;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public void setLastAccess(long lastAccessed) {
            this.lastAccess = lastAccessed;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }
    }
}

