/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.tags.TagKey;

public class TagNetworkSerialization {
    public static Map<ResourceKey<? extends Registry<?>>, NetworkPayload> serializeTagsToNetwork(LayeredRegistryAccess<RegistryLayer> dynamicRegistryManager) {
        return RegistrySynchronization.networkSafeRegistries(dynamicRegistryManager).map(registry -> Pair.of(registry.key(), (Object)TagNetworkSerialization.serializeToNetwork(registry.value()))).filter(pair -> ((NetworkPayload)pair.getSecond()).size() > 0).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private static <T> NetworkPayload serializeToNetwork(Registry<T> registry) {
        HashMap<ResourceLocation, IntList> map = new HashMap<ResourceLocation, IntList>();
        registry.getTags().forEach(pair -> {
            HolderSet holderSet = (HolderSet)pair.getSecond();
            IntArrayList intList = new IntArrayList(holderSet.size());
            for (Holder holder : holderSet) {
                if (holder.kind() != Holder.Kind.REFERENCE) {
                    throw new IllegalStateException("Can't serialize unregistered value " + String.valueOf(holder));
                }
                intList.add(registry.getId(holder.value()));
            }
            map.put(((TagKey)pair.getFirst()).location(), (IntList)intList);
        });
        return new NetworkPayload(map);
    }

    static <T> void deserializeTagsFromNetwork(ResourceKey<? extends Registry<T>> registryKey, Registry<T> registry, NetworkPayload serialized, TagOutput<T> loader) {
        serialized.tags.forEach((tagId, rawIds) -> {
            TagKey tagKey = TagKey.create(registryKey, tagId);
            List list = rawIds.intStream().mapToObj(registry::getHolder).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
            loader.accept(tagKey, list);
        });
    }

    public static final class NetworkPayload {
        final Map<ResourceLocation, IntList> tags;

        NetworkPayload(Map<ResourceLocation, IntList> contents) {
            this.tags = contents;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeMap(this.tags, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeIntIdList);
        }

        public static NetworkPayload read(FriendlyByteBuf buf) {
            return new NetworkPayload(buf.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readIntIdList));
        }

        public int size() {
            return this.tags.size();
        }

        public <T> void applyToRegistry(Registry<T> registry) {
            if (this.size() == 0) {
                return;
            }
            HashMap map = new HashMap(this.size());
            TagNetworkSerialization.deserializeTagsFromNetwork(registry.key(), registry, this, map::put);
            registry.bindTags(map);
        }
    }

    @FunctionalInterface
    public static interface TagOutput<T> {
        public void accept(TagKey<T> var1, List<Holder<T>> var2);
    }
}

