/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class DependencySorter<K, V extends Entry<K>> {
    private final Map<K, V> contents = new HashMap();

    public DependencySorter<K, V> addEntry(K key, V value) {
        this.contents.put(key, value);
        return this;
    }

    private void visitDependenciesAndElement(Multimap<K, K> parentChild, Set<K> visited, K rootKey, BiConsumer<K, V> callback) {
        if (!visited.add(rootKey)) {
            return;
        }
        parentChild.get(rootKey).forEach(child -> this.visitDependenciesAndElement(parentChild, visited, child, callback));
        Entry entry = (Entry)this.contents.get(rootKey);
        if (entry != null) {
            callback.accept(rootKey, entry);
        }
    }

    private static <K> boolean isCyclic(Multimap<K, K> dependencies, K key, K dependency) {
        Collection collection = dependencies.get(dependency);
        if (collection.contains(key)) {
            return true;
        }
        return collection.stream().anyMatch(subdependency -> DependencySorter.isCyclic(dependencies, key, subdependency));
    }

    private static <K> void addDependencyIfNotCyclic(Multimap<K, K> dependencies, K key, K dependency) {
        if (!DependencySorter.isCyclic(dependencies, key, dependency)) {
            dependencies.put(key, dependency);
        }
    }

    public void orderByDependencies(BiConsumer<K, V> callback) {
        HashMultimap multimap = HashMultimap.create();
        this.contents.forEach((arg_0, arg_1) -> DependencySorter.lambda$orderByDependencies$3((Multimap)multimap, arg_0, arg_1));
        this.contents.forEach((arg_0, arg_1) -> DependencySorter.lambda$orderByDependencies$5((Multimap)multimap, arg_0, arg_1));
        HashSet set = new HashSet();
        this.contents.keySet().forEach(arg_0 -> this.lambda$orderByDependencies$6((Multimap)multimap, set, callback, arg_0));
    }

    private /* synthetic */ void lambda$orderByDependencies$6(Multimap multimap, Set set, BiConsumer biConsumer, Object key) {
        this.visitDependenciesAndElement(multimap, set, key, biConsumer);
    }

    private static /* synthetic */ void lambda$orderByDependencies$5(Multimap multimap, Object key, Entry value) {
        value.visitOptionalDependencies(dependency -> DependencySorter.addDependencyIfNotCyclic(multimap, key, dependency));
    }

    private static /* synthetic */ void lambda$orderByDependencies$3(Multimap multimap, Object key, Entry value) {
        value.visitRequiredDependencies(dependency -> DependencySorter.addDependencyIfNotCyclic(multimap, key, dependency));
    }

    public static interface Entry<K> {
        public void visitRequiredDependencies(Consumer<K> var1);

        public void visitOptionalDependencies(Consumer<K> var1);
    }
}

