/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.util.ExtraCodecs;

public record InclusiveRange<T extends Comparable<T>>(T minInclusive, T maxInclusive) {
    public static final Codec<InclusiveRange<Integer>> INT = InclusiveRange.codec(Codec.INT);

    public InclusiveRange {
        if (minInclusive.compareTo(maxInclusive) > 0) {
            throw new IllegalArgumentException("min_inclusive must be less than or equal to max_inclusive");
        }
    }

    public InclusiveRange(T value) {
        this(value, value);
    }

    public static <T extends Comparable<T>> Codec<InclusiveRange<T>> codec(Codec<T> elementCodec) {
        return ExtraCodecs.intervalCodec(elementCodec, "min_inclusive", "max_inclusive", InclusiveRange::create, InclusiveRange::minInclusive, InclusiveRange::maxInclusive);
    }

    public static <T extends Comparable<T>> Codec<InclusiveRange<T>> codec(Codec<T> codec, T minInclusive, T maxInclusive) {
        return InclusiveRange.codec(codec).validate(range -> {
            if (range.minInclusive().compareTo(minInclusive) < 0) {
                return DataResult.error(() -> "Range limit too low, expected at least " + String.valueOf(minInclusive) + " [" + String.valueOf(range.minInclusive()) + "-" + String.valueOf(range.maxInclusive()) + "]");
            }
            if (range.maxInclusive().compareTo(maxInclusive) > 0) {
                return DataResult.error(() -> "Range limit too high, expected at most " + String.valueOf(maxInclusive) + " [" + String.valueOf(range.minInclusive()) + "-" + String.valueOf(range.maxInclusive()) + "]");
            }
            return DataResult.success((Object)range);
        });
    }

    public static <T extends Comparable<T>> DataResult<InclusiveRange<T>> create(T minInclusive, T maxInclusive) {
        if (minInclusive.compareTo(maxInclusive) <= 0) {
            return DataResult.success(new InclusiveRange<T>(minInclusive, maxInclusive));
        }
        return DataResult.error(() -> "min_inclusive must be less than or equal to max_inclusive");
    }

    public boolean isValueInRange(T value) {
        return value.compareTo(this.minInclusive) >= 0 && value.compareTo(this.maxInclusive) <= 0;
    }

    public boolean contains(InclusiveRange<T> other) {
        return other.minInclusive().compareTo(this.minInclusive) >= 0 && other.maxInclusive.compareTo(this.maxInclusive) <= 0;
    }

    @Override
    @Override
    public String toString() {
        return "[" + String.valueOf(this.minInclusive) + ", " + String.valueOf(this.maxInclusive) + "]";
    }
}

