/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.SectionPos;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class BlendingDataFix
extends DataFix {
    private final String name;
    private static final Set<String> STATUSES_TO_SKIP_BLENDING = Set.of("minecraft:empty", "minecraft:structure_starts", "minecraft:structure_references", "minecraft:biomes");

    public BlendingDataFix(Schema outputSchema) {
        super(outputSchema, false);
        this.name = "Blending Data Fix v" + outputSchema.getVersionKey();
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(References.CHUNK);
        return this.fixTypeEverywhereTyped(this.name, type, typed -> typed.update(DSL.remainderFinder(), chunk -> BlendingDataFix.updateChunkTag(chunk, chunk.get("__context"))));
    }

    private static Dynamic<?> updateChunkTag(Dynamic<?> chunk, OptionalDynamic<?> context) {
        chunk = chunk.remove("blending_data");
        boolean bl = "minecraft:overworld".equals(context.get("dimension").asString().result().orElse(""));
        Optional optional = chunk.get("Status").result();
        if (bl && optional.isPresent()) {
            Dynamic dynamic;
            String string2;
            String string = NamespacedSchema.ensureNamespaced(((Dynamic)((Object)optional.get())).asString("empty"));
            Optional optional2 = chunk.get("below_zero_retrogen").result();
            if (!STATUSES_TO_SKIP_BLENDING.contains(string)) {
                chunk = BlendingDataFix.updateBlendingData(chunk, 384, -64);
            } else if (optional2.isPresent() && !STATUSES_TO_SKIP_BLENDING.contains(string2 = NamespacedSchema.ensureNamespaced((dynamic = (Dynamic)((Object)optional2.get())).get("target_status").asString("empty")))) {
                chunk = BlendingDataFix.updateBlendingData(chunk, 256, 0);
            }
        }
        return chunk;
    }

    private static Dynamic<?> updateBlendingData(Dynamic<?> dynamic, int height, int minY) {
        return dynamic.set("blending_data", dynamic.createMap(Map.of(dynamic.createString("min_section"), dynamic.createInt(SectionPos.blockToSectionCoord(minY)), dynamic.createString("max_section"), dynamic.createInt(SectionPos.blockToSectionCoord(minY + height)))));
    }
}

