/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.References;
import org.apache.commons.lang3.mutable.MutableInt;

public class ChunkProtoTickListFix
extends DataFix {
    private static final int SECTION_WIDTH = 16;
    private static final ImmutableSet<String> ALWAYS_WATERLOGGED = ImmutableSet.of((Object)"minecraft:bubble_column", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant", (Object)"minecraft:seagrass", (Object)"minecraft:tall_seagrass");

    public ChunkProtoTickListFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.CHUNK);
        OpticFinder opticFinder = type.findField("Level");
        OpticFinder opticFinder2 = opticFinder.type().findField("Sections");
        OpticFinder opticFinder3 = ((List.ListType)opticFinder2.type()).getElement().finder();
        OpticFinder opticFinder4 = opticFinder3.type().findField("block_states");
        OpticFinder opticFinder5 = opticFinder3.type().findField("biomes");
        OpticFinder opticFinder6 = opticFinder4.type().findField("palette");
        OpticFinder opticFinder7 = opticFinder.type().findField("TileTicks");
        return this.fixTypeEverywhereTyped("ChunkProtoTickListFix", type, chunkTyped -> chunkTyped.updateTyped(opticFinder, levelTyped -> {
            levelTyped = levelTyped.update(DSL.remainderFinder(), levelDynamic -> (Dynamic)((Object)((Object)((Object)((Object)DataFixUtils.orElse(levelDynamic.get("LiquidTicks").result().map(liquidTicksDynamic -> levelDynamic.set("fluid_ticks", (Dynamic<?>)((Object)((Object)((Object)((Object)liquidTicksDynamic))))).remove("LiquidTicks")), (Object)levelDynamic))))));
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)levelTyped.get(DSL.remainderFinder()))));
            MutableInt mutableInt = new MutableInt();
            Int2ObjectArrayMap int2ObjectMap = new Int2ObjectArrayMap();
            levelTyped.getOptionalTyped(opticFinder2).ifPresent(arg_0 -> ChunkProtoTickListFix.lambda$makeRule$7(opticFinder3, opticFinder5, mutableInt, opticFinder4, (Int2ObjectMap)int2ObjectMap, opticFinder6, arg_0));
            byte b = mutableInt.getValue().byteValue();
            levelTyped = levelTyped.update(DSL.remainderFinder(), levelDynamic -> levelDynamic.update("yPos", yDynamic -> yDynamic.createByte(b)));
            if (levelTyped.getOptionalTyped(opticFinder7).isPresent() || dynamic.get("fluid_ticks").result().isPresent()) {
                return levelTyped;
            }
            int i = dynamic.get("xPos").asInt(0);
            int j = dynamic.get("zPos").asInt(0);
            Dynamic<?> dynamic2 = this.makeTickList(dynamic, (Int2ObjectMap<Supplier<PoorMansPalettedContainer>>)int2ObjectMap, b, i, j, "LiquidsToBeTicked", ChunkProtoTickListFix::getLiquid);
            Dynamic<?> dynamic3 = this.makeTickList(dynamic, (Int2ObjectMap<Supplier<PoorMansPalettedContainer>>)int2ObjectMap, b, i, j, "ToBeTicked", ChunkProtoTickListFix::getBlock);
            Optional optional = opticFinder7.type().readTyped(dynamic3).result();
            if (optional.isPresent()) {
                levelTyped = levelTyped.set(opticFinder7, (Typed)((Pair)optional.get()).getFirst());
            }
            return levelTyped.update(DSL.remainderFinder(), levelDynamic -> levelDynamic.remove("ToBeTicked").remove("LiquidsToBeTicked").set("fluid_ticks", dynamic2));
        }));
    }

    private Dynamic<?> makeTickList(Dynamic<?> levelDynamic, Int2ObjectMap<Supplier<PoorMansPalettedContainer>> palettedSectionsByY, byte sectionY, int localX, int localZ, String key, Function<Dynamic<?>, String> blockIdGetter) {
        Stream<Object> stream = Stream.empty();
        List list = levelDynamic.get(key).asList(Function.identity());
        for (int i = 0; i < list.size(); ++i) {
            int j = i + sectionY;
            Supplier supplier = (Supplier)palettedSectionsByY.get(j);
            Stream<Dynamic> stream2 = ((Dynamic)((Object)list.get(i))).asStream().mapToInt(posDynamic -> posDynamic.asShort((short)-1)).filter(packedLocalPos -> packedLocalPos > 0).mapToObj(arg_0 -> this.lambda$makeTickList$15(levelDynamic, (Supplier)supplier, localX, j, localZ, blockIdGetter, arg_0));
            stream = Stream.concat(stream, stream2);
        }
        return levelDynamic.createList(stream);
    }

    private static String getBlock(@Nullable Dynamic<?> blockStateDynamic) {
        return blockStateDynamic != null ? blockStateDynamic.get("Name").asString("minecraft:air") : "minecraft:air";
    }

    private static String getLiquid(@Nullable Dynamic<?> blockStateDynamic) {
        if (blockStateDynamic == null) {
            return "minecraft:empty";
        }
        String string = blockStateDynamic.get("Name").asString("");
        if ("minecraft:water".equals(string)) {
            return blockStateDynamic.get("Properties").get("level").asInt(0) == 0 ? "minecraft:water" : "minecraft:flowing_water";
        }
        if ("minecraft:lava".equals(string)) {
            return blockStateDynamic.get("Properties").get("level").asInt(0) == 0 ? "minecraft:lava" : "minecraft:flowing_lava";
        }
        if (ALWAYS_WATERLOGGED.contains((Object)string) || blockStateDynamic.get("Properties").get("waterlogged").asBoolean(false)) {
            return "minecraft:water";
        }
        return "minecraft:empty";
    }

    private Dynamic<?> createTick(Dynamic<?> levelDynamic, @Nullable Supplier<PoorMansPalettedContainer> sectionSupplier, int sectionX, int sectionY, int sectionZ, int packedLocalPos, Function<Dynamic<?>, String> blockIdGetter) {
        int i = packedLocalPos & 0xF;
        int j = packedLocalPos >>> 4 & 0xF;
        int k = packedLocalPos >>> 8 & 0xF;
        String string = blockIdGetter.apply(sectionSupplier != null ? sectionSupplier.get().get(i, j, k) : null);
        return levelDynamic.createMap((Map)ImmutableMap.builder().put((Object)levelDynamic.createString("i"), (Object)levelDynamic.createString(string)).put((Object)levelDynamic.createString("x"), (Object)levelDynamic.createInt(sectionX * 16 + i)).put((Object)levelDynamic.createString("y"), (Object)levelDynamic.createInt(sectionY * 16 + j)).put((Object)levelDynamic.createString("z"), (Object)levelDynamic.createInt(sectionZ * 16 + k)).put((Object)levelDynamic.createString("t"), (Object)levelDynamic.createInt(0)).put((Object)levelDynamic.createString("p"), (Object)levelDynamic.createInt(0)).build());
    }

    private /* synthetic */ Dynamic lambda$makeTickList$15(Dynamic dynamic, Supplier supplier, int i, int j, int k, Function function, int packedLocalPos) {
        return this.createTick(dynamic, supplier, i, j, k, packedLocalPos, function);
    }

    private static /* synthetic */ void lambda$makeRule$7(OpticFinder opticFinder, OpticFinder opticFinder2, MutableInt mutableInt, OpticFinder opticFinder3, Int2ObjectMap int2ObjectMap, OpticFinder opticFinder4, Typed sectionsTyped) {
        sectionsTyped.getAllTyped(opticFinder).forEach(sectionTyped -> {
            Dynamic dynamic = (Dynamic)((Object)((Object)sectionTyped.get(DSL.remainderFinder())));
            int i = dynamic.get("Y").asInt(Integer.MAX_VALUE);
            if (i == Integer.MAX_VALUE) {
                return;
            }
            if (sectionTyped.getOptionalTyped(opticFinder2).isPresent()) {
                mutableInt.setValue(Math.min(i, mutableInt.getValue()));
            }
            sectionTyped.getOptionalTyped(opticFinder3).ifPresent(blockStatesTyped -> int2ObjectMap.put(i, (Object)Suppliers.memoize(() -> {
                List list = blockStatesTyped.getOptionalTyped(opticFinder4).map(paletteTyped -> paletteTyped.write().result().map(paletteDynamic -> paletteDynamic.asList(Function.identity())).orElse(Collections.emptyList())).orElse(Collections.emptyList());
                long[] ls = ((Dynamic)((Object)((Object)((Object)((Object)blockStatesTyped.get(DSL.remainderFinder())))))).get("data").asLongStream().toArray();
                return new PoorMansPalettedContainer(list, ls);
            })));
        });
    }

    public static final class PoorMansPalettedContainer {
        private static final long SIZE_BITS = 4L;
        private final List<? extends Dynamic<?>> palette;
        private final long[] data;
        private final int bits;
        private final long mask;
        private final int valuesPerLong;

        public PoorMansPalettedContainer(List<? extends Dynamic<?>> palette, long[] data) {
            this.palette = palette;
            this.data = data;
            this.bits = Math.max(4, ChunkHeightAndBiomeFix.ceillog2(palette.size()));
            this.mask = (1L << this.bits) - 1L;
            this.valuesPerLong = (char)(64 / this.bits);
        }

        @Nullable
        public Dynamic<?> get(int localX, int localY, int localZ) {
            int i = this.palette.size();
            if (i < 1) {
                return null;
            }
            if (i == 1) {
                return this.palette.get(0);
            }
            int j = this.getIndex(localX, localY, localZ);
            int k = j / this.valuesPerLong;
            if (k < 0 || k >= this.data.length) {
                return null;
            }
            long l = this.data[k];
            int m = (j - k * this.valuesPerLong) * this.bits;
            int n = (int)(l >> m & this.mask);
            if (n < 0 || n >= i) {
                return null;
            }
            return this.palette.get(n);
        }

        private int getIndex(int localX, int localY, int localZ) {
            return (localY << 4 | localZ) << 4 | localX;
        }

        public List<? extends Dynamic<?>> palette() {
            return this.palette;
        }

        public long[] data() {
            return this.data;
        }
    }
}

