/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.util.datafix.fixes.NamedEntityFix;

public class EntityVariantFix
extends NamedEntityFix {
    private final String fieldName;
    private final IntFunction<String> idConversions;

    public EntityVariantFix(Schema outputSchema, String name, DSL.TypeReference type, String entityId, String variantKey, IntFunction<String> variantIntToId) {
        super(outputSchema, false, name, type, entityId);
        this.fieldName = variantKey;
        this.idConversions = variantIntToId;
    }

    private static <T> Dynamic<T> updateAndRename(Dynamic<T> entityDynamic, String oldVariantKey, String newVariantKey, Function<Dynamic<T>, Dynamic<T>> variantIntToId) {
        return entityDynamic.map(object3 -> {
            DynamicOps dynamicOps = entityDynamic.getOps();
            Function<Object, Object> function2 = object -> ((Dynamic)((Object)((Object)((Object)variantIntToId.apply(new Dynamic<Object>(dynamicOps, object)))))).getValue();
            return dynamicOps.get(object3, oldVariantKey).map(object2 -> dynamicOps.set(object3, newVariantKey, function2.apply(object2))).result().orElse(object3);
        });
    }

    @Override
    @Override
    protected Typed<?> fix(Typed<?> inputTyped) {
        return inputTyped.update(DSL.remainderFinder(), entityDynamic -> EntityVariantFix.updateAndRename(entityDynamic, this.fieldName, "variant", variantDynamic -> (Dynamic)((Object)((Object)((Object)DataFixUtils.orElse((Optional)variantDynamic.asNumber().map(variantInt -> variantDynamic.createString(this.idConversions.apply(variantInt.intValue()))).result(), (Object)variantDynamic))))));
    }
}

