/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.EntityRenameFix;
import net.minecraft.util.datafix.fixes.References;

public class EntityZombieSplitFix
extends EntityRenameFix {
    private final Supplier<Type<?>> zombieVillagerType = Suppliers.memoize(() -> this.getOutputSchema().getChoiceType(References.ENTITY, "ZombieVillager"));

    public EntityZombieSplitFix(Schema outputSchema) {
        super("EntityZombieSplitFix", outputSchema, true);
    }

    @Override
    @Override
    protected Pair<String, Typed<?>> fix(String choice, Typed<?> entityTyped) {
        Typed<?> typed3;
        String string3;
        if (!choice.equals("Zombie")) {
            return Pair.of((Object)choice, entityTyped);
        }
        Dynamic dynamic = (Dynamic)((Object)entityTyped.getOptional(DSL.remainderFinder()).orElseThrow());
        int i = dynamic.get("ZombieType").asInt(0);
        switch (i) {
            default: {
                String string = "Zombie";
                Typed<?> typed = entityTyped;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                String string2 = "ZombieVillager";
                Typed<?> typed2 = this.changeSchemaToZombieVillager(entityTyped, i - 1);
                break;
            }
            case 6: {
                string3 = "Husk";
                typed3 = entityTyped;
            }
        }
        return Pair.of((Object)string3, (Object)typed3.update(DSL.remainderFinder(), entityDynamic -> entityDynamic.remove("ZombieType")));
    }

    private Typed<?> changeSchemaToZombieVillager(Typed<?> entityTyped, int variant) {
        return Util.writeAndReadTypedOrThrow(entityTyped, this.zombieVillagerType.get(), zombieVillagerDynamic -> zombieVillagerDynamic.set("Profession", zombieVillagerDynamic.createInt(variant)));
    }
}

