/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.util.datafix.fixes.BlockStateData;
import net.minecraft.util.datafix.fixes.EntityBlockStateFix;
import net.minecraft.util.datafix.fixes.References;
import org.apache.commons.lang3.math.NumberUtils;

public class LevelFlatGeneratorInfoFix
extends DataFix {
    private static final String GENERATOR_OPTIONS = "generatorOptions";
    @VisibleForTesting
    static final String DEFAULT = "minecraft:bedrock,2*minecraft:dirt,minecraft:grass_block;1;village";
    private static final Splitter SPLITTER = Splitter.on((char)';').limit(5);
    private static final Splitter LAYER_SPLITTER = Splitter.on((char)',');
    private static final Splitter OLD_AMOUNT_SPLITTER = Splitter.on((char)'x').limit(2);
    private static final Splitter AMOUNT_SPLITTER = Splitter.on((char)'*').limit(2);
    private static final Splitter BLOCK_SPLITTER = Splitter.on((char)':').limit(3);

    public LevelFlatGeneratorInfoFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("LevelFlatGeneratorInfoFix", this.getInputSchema().getType(References.LEVEL), levelTyped -> levelTyped.update(DSL.remainderFinder(), this::fix));
    }

    private Dynamic<?> fix(Dynamic<?> levelDynamic) {
        if (levelDynamic.get("generatorName").asString("").equalsIgnoreCase("flat")) {
            return levelDynamic.update(GENERATOR_OPTIONS, generatorOptionsDynamic -> (Dynamic)((Object)((Object)DataFixUtils.orElse((Optional)generatorOptionsDynamic.asString().map(this::fixString).map(arg_0 -> ((Dynamic)((Object)generatorOptionsDynamic)).createString(arg_0)).result(), (Object)generatorOptionsDynamic))));
        }
        return levelDynamic;
    }

    @VisibleForTesting
    String fixString(String generatorOptions) {
        String string3;
        int j;
        if (generatorOptions.isEmpty()) {
            return DEFAULT;
        }
        Iterator iterator = SPLITTER.split((CharSequence)generatorOptions).iterator();
        String string2 = (String)iterator.next();
        if (iterator.hasNext()) {
            int i = NumberUtils.toInt((String)string2, (int)0);
            String string22 = (String)iterator.next();
        } else {
            j = 0;
            string3 = string2;
        }
        if (j < 0 || j > 3) {
            return DEFAULT;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Splitter splitter = j < 3 ? OLD_AMOUNT_SPLITTER : AMOUNT_SPLITTER;
        stringBuilder.append(StreamSupport.stream(LAYER_SPLITTER.split((CharSequence)string3).spliterator(), false).map(string -> {
            String string3;
            int k;
            List list = splitter.splitToList((CharSequence)string);
            if (list.size() == 2) {
                int j = NumberUtils.toInt((String)((String)list.get(0)));
                String string2 = (String)list.get(1);
            } else {
                k = 1;
                string3 = (String)list.get(0);
            }
            List list2 = BLOCK_SPLITTER.splitToList((CharSequence)string3);
            int l = ((String)list2.get(0)).equals("minecraft") ? 1 : 0;
            String string4 = (String)list2.get(l);
            int m = j == 3 ? EntityBlockStateFix.getBlockId("minecraft:" + string4) : NumberUtils.toInt((String)string4, (int)0);
            int n = l + 1;
            int o = list2.size() > n ? NumberUtils.toInt((String)((String)list2.get(n)), (int)0) : 0;
            return (String)(k == 1 ? "" : k + "*") + BlockStateData.getTag(m << 4 | o).get("Name").asString("");
        }).collect(Collectors.joining(",")));
        while (iterator.hasNext()) {
            stringBuilder.append(';').append((String)iterator.next());
        }
        return stringBuilder.toString();
    }
}

