/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;

public class OverreachingTickFix
extends DataFix {
    public OverreachingTickFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.CHUNK);
        OpticFinder opticFinder = type.findField("block_ticks");
        return this.fixTypeEverywhereTyped("Handle ticks saved in the wrong chunk", type, chunkTyped -> {
            Optional optional = chunkTyped.getOptionalTyped(opticFinder);
            Optional optional2 = optional.isPresent() ? ((Typed)optional.get()).write().result() : Optional.empty();
            return chunkTyped.update(DSL.remainderFinder(), chunkTag -> {
                int i = chunkTag.get("xPos").asInt(0);
                int j = chunkTag.get("zPos").asInt(0);
                Optional optional2 = chunkTag.get("fluid_ticks").get().result();
                chunkTag = OverreachingTickFix.extractOverreachingTicks(chunkTag, i, j, optional2, "neighbor_block_ticks");
                chunkTag = OverreachingTickFix.extractOverreachingTicks(chunkTag, i, j, optional2, "neighbor_fluid_ticks");
                return chunkTag;
            });
        });
    }

    private static Dynamic<?> extractOverreachingTicks(Dynamic<?> chunkTag, int chunkX, int chunkZ, Optional<? extends Dynamic<?>> ticks, String upgradeDataKey) {
        List<Dynamic> list;
        if (ticks.isPresent() && !(list = ticks.get().asStream().filter(tickDynamic -> {
            int k = tickDynamic.get("x").asInt(0);
            int l = tickDynamic.get("z").asInt(0);
            int m = Math.abs(chunkX - (k >> 4));
            int n = Math.abs(chunkZ - (l >> 4));
            return (m != 0 || n != 0) && m <= 1 && n <= 1;
        }).toList()).isEmpty()) {
            chunkTag = chunkTag.set("UpgradeData", chunkTag.get("UpgradeData").orElseEmptyMap().set(upgradeDataKey, chunkTag.createList(list.stream())));
        }
        return chunkTag;
    }
}

