/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.ErrorCollector;
import net.minecraft.util.parsing.packrat.Rule;

public abstract class ParseState<S> {
    private final Map<CacheKey<?>, CacheEntry<?>> ruleCache = new HashMap();
    private final Dictionary<S> dictionary;
    private final ErrorCollector<S> errorCollector;

    protected ParseState(Dictionary<S> rules, ErrorCollector<S> errors) {
        this.dictionary = rules;
        this.errorCollector = errors;
    }

    public ErrorCollector<S> errorCollector() {
        return this.errorCollector;
    }

    public <T> Optional<T> parseTopRule(Atom<T> startSymbol) {
        Optional<T> optional = this.parse(startSymbol);
        if (optional.isPresent()) {
            this.errorCollector.finish(this.mark());
        }
        return optional;
    }

    public <T> Optional<T> parse(Atom<T> symbol) {
        CacheKey<T> cacheKey = new CacheKey<T>(symbol, this.mark());
        CacheEntry<T> cacheEntry = this.lookupInCache(cacheKey);
        if (cacheEntry != null) {
            this.restore(cacheEntry.mark());
            return cacheEntry.value;
        }
        Rule<S, T> rule = this.dictionary.get(symbol);
        if (rule == null) {
            throw new IllegalStateException("No symbol " + String.valueOf(symbol));
        }
        Optional<T> optional = rule.parse(this);
        this.storeInCache(cacheKey, optional);
        return optional;
    }

    @Nullable
    private <T> CacheEntry<T> lookupInCache(CacheKey<T> key) {
        return this.ruleCache.get(key);
    }

    private <T> void storeInCache(CacheKey<T> key, Optional<T> value) {
        this.ruleCache.put(key, new CacheEntry<T>(value, this.mark()));
    }

    public abstract S input();

    public abstract int mark();

    public abstract void restore(int var1);

    record CacheKey<T>(Atom<T> name, int mark) {
    }

    record CacheEntry<T>(Optional<T> value, int mark) {
    }
}

