/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.profiling.jfr.parse.JfrStatsParser;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class SummaryReporter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Runnable onDeregistration;

    protected SummaryReporter(Runnable stopCallback) {
        this.onDeregistration = stopCallback;
    }

    /*
     * WARNING - void declaration
     */
    public void recordingStopped(@Nullable Path dumpPath) {
        if (dumpPath == null) {
            return;
        }
        this.onDeregistration.run();
        SummaryReporter.infoWithFallback(() -> "Dumped flight recorder profiling to " + String.valueOf(dumpPath));
        try {
            JfrStatsResult jfrStatsResult = JfrStatsParser.parse(dumpPath);
        }
        catch (Throwable throwable) {
            SummaryReporter.warnWithFallback(() -> "Failed to parse JFR recording", throwable);
            return;
        }
        try {
            void jfrStatsResult2;
            SummaryReporter.infoWithFallback(((JfrStatsResult)jfrStatsResult2)::asJson);
            Path path = dumpPath.resolveSibling("jfr-report-" + StringUtils.substringBefore((String)dumpPath.getFileName().toString(), (String)".jfr") + ".json");
            Files.writeString(path, (CharSequence)jfrStatsResult2.asJson(), StandardOpenOption.CREATE);
            SummaryReporter.infoWithFallback(() -> "Dumped recording summary to " + String.valueOf(path));
        }
        catch (Throwable throwable2) {
            SummaryReporter.warnWithFallback(() -> "Failed to output JFR report", throwable2);
        }
    }

    private static void infoWithFallback(Supplier<String> logSupplier) {
        if (LogUtils.isLoggerActive()) {
            LOGGER.info(logSupplier.get());
        } else {
            Bootstrap.realStdoutPrintln(logSupplier.get());
        }
    }

    private static void warnWithFallback(Supplier<String> logSupplier, Throwable throwable) {
        if (LogUtils.isLoggerActive()) {
            LOGGER.warn(logSupplier.get(), throwable);
        } else {
            Bootstrap.realStdoutPrintln(logSupplier.get());
            throwable.printStackTrace(Bootstrap.STDOUT);
        }
    }
}

