/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public record FileIOStat(Duration duration, @Nullable String path, long bytes) {
    public static Summary summary(Duration duration, List<FileIOStat> samples) {
        long l = samples.stream().mapToLong(sample -> sample.bytes).sum();
        return new Summary(l, (double)l / (double)duration.getSeconds(), samples.size(), (double)samples.size() / (double)duration.getSeconds(), samples.stream().map(FileIOStat::duration).reduce(Duration.ZERO, Duration::plus), samples.stream().filter(sample -> sample.path != null).collect(Collectors.groupingBy(sample -> sample.path, Collectors.summingLong(sample -> sample.bytes))).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((Long)entry.getValue()))).limit(10L).toList());
    }

    public record Summary(long totalBytes, double bytesPerSecond, long counts, double countsPerSecond, Duration timeSpentInIO, List<Pair<String, Long>> topTenContributorsByTotalBytes) {
    }
}

