/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.jfr.consumer.RecordedEvent;

public record GcHeapStat(Instant timestamp, long heapUsed, Timing timing) {
    public static GcHeapStat from(RecordedEvent event) {
        return new GcHeapStat(event.getStartTime(), event.getLong("heapUsed"), event.getString("when").equalsIgnoreCase("before gc") ? Timing.BEFORE_GC : Timing.AFTER_GC);
    }

    public static Summary summary(Duration duration, List<GcHeapStat> samples, Duration gcDuration, int count) {
        return new Summary(duration, gcDuration, count, GcHeapStat.calculateAllocationRatePerSecond(samples));
    }

    private static double calculateAllocationRatePerSecond(List<GcHeapStat> samples) {
        long l = 0L;
        Map<Timing, List<GcHeapStat>> map = samples.stream().collect(Collectors.groupingBy(gcHeapStat -> gcHeapStat.timing));
        List<GcHeapStat> list = map.get((Object)Timing.BEFORE_GC);
        List<GcHeapStat> list2 = map.get((Object)Timing.AFTER_GC);
        for (int i = 1; i < list.size(); ++i) {
            GcHeapStat gcHeapStat2 = list.get(i);
            GcHeapStat gcHeapStat22 = list2.get(i - 1);
            l += gcHeapStat2.heapUsed - gcHeapStat22.heapUsed;
        }
        Duration duration = Duration.between(samples.get((int)1).timestamp, samples.get((int)(samples.size() - 1)).timestamp);
        return (double)l / (double)duration.getSeconds();
    }

    static enum Timing {
        BEFORE_GC,
        AFTER_GC;

    }

    public record Summary(Duration duration, Duration gcTotalDuration, int totalGCs, double allocationRateBytesPerSecond) {
        public float gcOverHead() {
            return (float)this.gcTotalDuration.toMillis() / (float)this.duration.toMillis();
        }
    }
}

