/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;

public class MetricsRegistry {
    public static final MetricsRegistry INSTANCE = new MetricsRegistry();
    private final WeakHashMap<ProfilerMeasured, Void> measuredInstances = new WeakHashMap();

    private MetricsRegistry() {
    }

    public void add(ProfilerMeasured executor) {
        this.measuredInstances.put(executor, null);
    }

    public List<MetricSampler> getRegisteredSamplers() {
        Map<String, List<MetricSampler>> map = this.measuredInstances.keySet().stream().flatMap(executor -> executor.profiledMetrics().stream()).collect(Collectors.groupingBy(MetricSampler::getName));
        return MetricsRegistry.aggregateDuplicates(map);
    }

    private static List<MetricSampler> aggregateDuplicates(Map<String, List<MetricSampler>> samplers) {
        return samplers.entrySet().stream().map(entry -> {
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            return list.size() > 1 ? new AggregatedMetricSampler(string, list) : (MetricSampler)list.get(0);
        }).collect(Collectors.toList());
    }

    static class AggregatedMetricSampler
    extends MetricSampler {
        private final List<MetricSampler> delegates;

        AggregatedMetricSampler(String id, List<MetricSampler> delegates) {
            super(id, delegates.get(0).getCategory(), () -> AggregatedMetricSampler.averageValueFromDelegates(delegates), () -> AggregatedMetricSampler.beforeTick(delegates), AggregatedMetricSampler.thresholdTest(delegates));
            this.delegates = delegates;
        }

        private static MetricSampler.ThresholdTest thresholdTest(List<MetricSampler> delegates) {
            return value -> delegates.stream().anyMatch(sampler -> {
                if (sampler.thresholdTest != null) {
                    return sampler.thresholdTest.test(value);
                }
                return false;
            });
        }

        private static void beforeTick(List<MetricSampler> samplers) {
            for (MetricSampler metricSampler : samplers) {
                metricSampler.onStartTick();
            }
        }

        private static double averageValueFromDelegates(List<MetricSampler> samplers) {
            double d = 0.0;
            for (MetricSampler metricSampler : samplers) {
                d += metricSampler.getSampler().getAsDouble();
            }
            return d / (double)samplers.size();
        }

        @Override
        @Override
        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            AggregatedMetricSampler aggregatedMetricSampler = (AggregatedMetricSampler)object;
            return this.delegates.equals(aggregatedMetricSampler.delegates);
        }

        @Override
        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.delegates);
        }
    }
}

