/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ProcessorHandle<Msg>
extends AutoCloseable {
    public String name();

    public void tell(Msg var1);

    @Override
    @Override
    default public void close() {
    }

    default public <Source> CompletableFuture<Source> ask(Function<? super ProcessorHandle<Source>, ? extends Msg> messageProvider) {
        CompletableFuture completableFuture = new CompletableFuture();
        Msg object = messageProvider.apply(ProcessorHandle.of("ask future procesor handle", completableFuture::complete));
        this.tell(object);
        return completableFuture;
    }

    default public <Source> CompletableFuture<Source> askEither(Function<? super ProcessorHandle<Either<Source, Exception>>, ? extends Msg> messageProvider) {
        CompletableFuture completableFuture = new CompletableFuture();
        Msg object = messageProvider.apply(ProcessorHandle.of("ask future procesor handle", either -> {
            either.ifLeft(completableFuture::complete);
            either.ifRight(completableFuture::completeExceptionally);
        }));
        this.tell(object);
        return completableFuture;
    }

    public static <Msg> ProcessorHandle<Msg> of(final String name, final Consumer<Msg> action) {
        return new ProcessorHandle<Msg>(){

            @Override
            @Override
            public String name() {
                return name;
            }

            @Override
            @Override
            public void tell(Msg message) {
                action.accept(message);
            }

            @Override
            public String toString() {
                return name;
            }
        };
    }
}

