/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class ClampedInt
extends IntProvider {
    public static final MapCodec<ClampedInt> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntProvider.CODEC.fieldOf("source").forGetter(provider -> provider.source), (App)Codec.INT.fieldOf("min_inclusive").forGetter(provider -> provider.minInclusive), (App)Codec.INT.fieldOf("max_inclusive").forGetter(provider -> provider.maxInclusive)).apply((Applicative)instance, ClampedInt::new)).validate(provider -> {
        if (provider.maxInclusive < provider.minInclusive) {
            return DataResult.error(() -> "Max must be at least min, min_inclusive: " + clampedInt.minInclusive + ", max_inclusive: " + clampedInt.maxInclusive);
        }
        return DataResult.success((Object)provider);
    });
    private final IntProvider source;
    private final int minInclusive;
    private final int maxInclusive;

    public static ClampedInt of(IntProvider source, int min, int max) {
        return new ClampedInt(source, min, max);
    }

    public ClampedInt(IntProvider source, int min, int max) {
        this.source = source;
        this.minInclusive = min;
        this.maxInclusive = max;
    }

    @Override
    @Override
    public int sample(RandomSource random) {
        return Mth.clamp(this.source.sample(random), this.minInclusive, this.maxInclusive);
    }

    @Override
    @Override
    public int getMinValue() {
        return Math.max(this.minInclusive, this.source.getMinValue());
    }

    @Override
    @Override
    public int getMaxValue() {
        return Math.min(this.maxInclusive, this.source.getMaxValue());
    }

    @Override
    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.CLAMPED;
    }
}

