/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class UniformInt
extends IntProvider {
    public static final MapCodec<UniformInt> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("min_inclusive").forGetter(provider -> provider.minInclusive), (App)Codec.INT.fieldOf("max_inclusive").forGetter(provider -> provider.maxInclusive)).apply((Applicative)instance, UniformInt::new)).validate(provider -> {
        if (provider.maxInclusive < provider.minInclusive) {
            return DataResult.error(() -> "Max must be at least min, min_inclusive: " + uniformInt.minInclusive + ", max_inclusive: " + uniformInt.maxInclusive);
        }
        return DataResult.success((Object)provider);
    });
    private final int minInclusive;
    private final int maxInclusive;

    private UniformInt(int min, int max) {
        this.minInclusive = min;
        this.maxInclusive = max;
    }

    public static UniformInt of(int min, int max) {
        return new UniformInt(min, max);
    }

    @Override
    @Override
    public int sample(RandomSource random) {
        return Mth.randomBetweenInclusive(random, this.minInclusive, this.maxInclusive);
    }

    @Override
    @Override
    public int getMinValue() {
        return this.minInclusive;
    }

    @Override
    @Override
    public int getMaxValue() {
        return this.maxInclusive;
    }

    @Override
    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.UNIFORM;
    }

    @Override
    public String toString() {
        return "[" + this.minInclusive + "-" + this.maxInclusive + "]";
    }
}

