/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.phys.Vec3;

public class BlockPosTracker
implements PositionTracker {
    private final BlockPos blockPos;
    private final Vec3 centerPosition;

    public BlockPosTracker(BlockPos blockPos) {
        this.blockPos = blockPos.immutable();
        this.centerPosition = Vec3.atCenterOf(blockPos);
    }

    public BlockPosTracker(Vec3 pos) {
        this.blockPos = BlockPos.containing(pos);
        this.centerPosition = pos;
    }

    @Override
    @Override
    public Vec3 currentPosition() {
        return this.centerPosition;
    }

    @Override
    @Override
    public BlockPos currentBlockPosition() {
        return this.blockPos;
    }

    @Override
    @Override
    public boolean isVisibleBy(LivingEntity entity) {
        return true;
    }

    @Override
    public String toString() {
        return "BlockPosTracker{blockPos=" + String.valueOf(this.blockPos) + ", centerPosition=" + String.valueOf(this.centerPosition) + "}";
    }
}

