/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class GateBehavior<E extends LivingEntity>
implements BehaviorControl<E> {
    private final Map<MemoryModuleType<?>, MemoryStatus> entryCondition;
    private final Set<MemoryModuleType<?>> exitErasedMemories;
    private final OrderPolicy orderPolicy;
    private final RunningPolicy runningPolicy;
    private final ShufflingList<BehaviorControl<? super E>> behaviors = new ShufflingList(false);
    private Behavior.Status status = Behavior.Status.STOPPED;

    public GateBehavior(Map<MemoryModuleType<?>, MemoryStatus> requiredMemoryState, Set<MemoryModuleType<?>> memoriesToForgetWhenStopped, OrderPolicy order, RunningPolicy runMode, List<Pair<? extends BehaviorControl<? super E>, Integer>> tasks) {
        this.entryCondition = requiredMemoryState;
        this.exitErasedMemories = memoriesToForgetWhenStopped;
        this.orderPolicy = order;
        this.runningPolicy = runMode;
        tasks.forEach(task -> this.behaviors.add((BehaviorControl)task.getFirst(), (Integer)task.getSecond()));
    }

    @Override
    public Behavior.Status getStatus() {
        return this.status;
    }

    private boolean hasRequiredMemories(E entity) {
        for (Map.Entry<MemoryModuleType<?>, MemoryStatus> entry : this.entryCondition.entrySet()) {
            MemoryModuleType<?> memoryModuleType = entry.getKey();
            MemoryStatus memoryStatus = entry.getValue();
            if (((LivingEntity)entity).getBrain().checkMemory(memoryModuleType, memoryStatus)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean tryStart(ServerLevel world, E entity, long time) {
        if (this.hasRequiredMemories(entity)) {
            this.status = Behavior.Status.RUNNING;
            this.orderPolicy.apply(this.behaviors);
            this.runningPolicy.apply(this.behaviors, world, entity, time);
            return true;
        }
        return false;
    }

    @Override
    public final void tickOrStop(ServerLevel world, E entity, long time) {
        for (BehaviorControl<E> task2 : this.behaviors) {
            if (task2.getStatus() != Behavior.Status.RUNNING) continue;
            task2.tickOrStop(world, entity, time);
        }
        if (this.behaviors.stream().noneMatch(task -> task.getStatus() == Behavior.Status.RUNNING)) {
            this.doStop(world, entity, time);
        }
    }

    @Override
    public final void doStop(ServerLevel world, E entity, long time) {
        this.status = Behavior.Status.STOPPED;
        for (BehaviorControl<E> behaviorControl : this.behaviors) {
            if (behaviorControl.getStatus() != Behavior.Status.RUNNING) continue;
            behaviorControl.doStop(world, entity, time);
        }
        for (MemoryModuleType memoryModuleType : this.exitErasedMemories) {
            ((LivingEntity)entity).getBrain().eraseMemory(memoryModuleType);
        }
    }

    @Override
    public String debugString() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        Set set = this.behaviors.stream().filter(task -> task.getStatus() == Behavior.Status.RUNNING).collect(Collectors.toSet());
        return "(" + this.getClass().getSimpleName() + "): " + String.valueOf(set);
    }

    public static enum OrderPolicy {
        ORDERED(list -> {}),
        SHUFFLED(ShufflingList::shuffle);

        private final Consumer<ShufflingList<?>> consumer;

        private OrderPolicy(Consumer<ShufflingList<?>> listModifier) {
            this.consumer = listModifier;
        }

        public void apply(ShufflingList<?> list) {
            this.consumer.accept(list);
        }
    }

    public static enum RunningPolicy {
        RUN_ONE{

            @Override
            public <E extends LivingEntity> void apply(ShufflingList<BehaviorControl<? super E>> tasks, ServerLevel world, E entity, long time) {
                for (BehaviorControl<E> task : tasks) {
                    if (task.getStatus() == Behavior.Status.STOPPED && task.tryStart(world, entity, time)) break;
                }
            }
        }
        ,
        TRY_ALL{

            @Override
            public <E extends LivingEntity> void apply(ShufflingList<BehaviorControl<? super E>> tasks, ServerLevel world, E entity, long time) {
                for (BehaviorControl<E> task : tasks) {
                    if (task.getStatus() != Behavior.Status.STOPPED) continue;
                    task.tryStart(world, entity, time);
                }
            }
        };


        public abstract <E extends LivingEntity> void apply(ShufflingList<BehaviorControl<? super E>> var1, ServerLevel var2, E var3, long var4);
    }
}

