/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class MoveToTargetSink
extends Behavior<Mob> {
    private static final int MAX_COOLDOWN_BEFORE_RETRYING = 40;
    private int remainingCooldown;
    @Nullable
    private Path path;
    @Nullable
    private BlockPos lastTargetPos;
    private float speedModifier;

    public MoveToTargetSink() {
        this(150, 250);
    }

    public MoveToTargetSink(int minRunTime, int maxRunTime) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.PATH, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), minRunTime, maxRunTime);
    }

    @Override
    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, Mob entity) {
        if (this.remainingCooldown > 0) {
            --this.remainingCooldown;
            return false;
        }
        Brain<?> brain = entity.getBrain();
        WalkTarget walkTarget = brain.getMemory(MemoryModuleType.WALK_TARGET).get();
        boolean bl = this.reachedTarget(entity, walkTarget);
        if (!bl && this.tryComputePath(entity, walkTarget, world.getGameTime())) {
            this.lastTargetPos = walkTarget.getTarget().currentBlockPosition();
            return true;
        }
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        if (bl) {
            brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        }
        return false;
    }

    @Override
    @Override
    protected boolean canStillUse(ServerLevel world, Mob entity, long time) {
        if (this.path == null || this.lastTargetPos == null) {
            return false;
        }
        Optional<WalkTarget> optional = entity.getBrain().getMemory(MemoryModuleType.WALK_TARGET);
        boolean bl = optional.map(MoveToTargetSink::isWalkTargetSpectator).orElse(false);
        PathNavigation pathNavigation = entity.getNavigation();
        return !pathNavigation.isDone() && optional.isPresent() && !this.reachedTarget(entity, optional.get()) && !bl;
    }

    @Override
    @Override
    protected void stop(ServerLevel world, Mob entity, long time) {
        if (entity.getBrain().hasMemoryValue(MemoryModuleType.WALK_TARGET) && !this.reachedTarget(entity, entity.getBrain().getMemory(MemoryModuleType.WALK_TARGET).get()) && entity.getNavigation().isStuck()) {
            this.remainingCooldown = world.getRandom().nextInt(40);
        }
        entity.getNavigation().stop();
        entity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        entity.getBrain().eraseMemory(MemoryModuleType.PATH);
        this.path = null;
    }

    @Override
    @Override
    protected void start(ServerLevel serverLevel, Mob mob, long l) {
        mob.getBrain().setMemory(MemoryModuleType.PATH, this.path);
        mob.getNavigation().moveTo(this.path, (double)this.speedModifier);
    }

    @Override
    @Override
    protected void tick(ServerLevel serverLevel, Mob mob, long l) {
        Path path = mob.getNavigation().getPath();
        Brain<?> brain = mob.getBrain();
        if (this.path != path) {
            this.path = path;
            brain.setMemory(MemoryModuleType.PATH, path);
        }
        if (path == null || this.lastTargetPos == null) {
            return;
        }
        WalkTarget walkTarget = brain.getMemory(MemoryModuleType.WALK_TARGET).get();
        if (walkTarget.getTarget().currentBlockPosition().distSqr(this.lastTargetPos) > 4.0 && this.tryComputePath(mob, walkTarget, serverLevel.getGameTime())) {
            this.lastTargetPos = walkTarget.getTarget().currentBlockPosition();
            this.start(serverLevel, mob, l);
        }
    }

    private boolean tryComputePath(Mob entity, WalkTarget walkTarget, long time) {
        BlockPos blockPos = walkTarget.getTarget().currentBlockPosition();
        this.path = entity.getNavigation().createPath(blockPos, 0);
        this.speedModifier = walkTarget.getSpeedModifier();
        Brain<Long> brain = entity.getBrain();
        if (this.reachedTarget(entity, walkTarget)) {
            brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        } else {
            boolean bl;
            boolean bl2 = bl = this.path != null && this.path.canReach();
            if (bl) {
                brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            } else if (!brain.hasMemoryValue(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)) {
                brain.setMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, time);
            }
            if (this.path != null) {
                return true;
            }
            Vec3 vec3 = DefaultRandomPos.getPosTowards((PathfinderMob)entity, 10, 7, Vec3.atBottomCenterOf(blockPos), 1.5707963705062866);
            if (vec3 != null) {
                this.path = entity.getNavigation().createPath(vec3.x, vec3.y, vec3.z, 0);
                return this.path != null;
            }
        }
        return false;
    }

    private boolean reachedTarget(Mob entity, WalkTarget walkTarget) {
        return walkTarget.getTarget().currentBlockPosition().distManhattan(entity.blockPosition()) <= walkTarget.getCloseEnoughDist();
    }

    private static boolean isWalkTargetSpectator(WalkTarget target) {
        PositionTracker positionTracker = target.getTarget();
        if (positionTracker instanceof EntityTracker) {
            EntityTracker entityTracker = (EntityTracker)positionTracker;
            return entityTracker.getEntity().isSpectator();
        }
        return false;
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel world, LivingEntity entity, long time) {
        this.tick(world, (Mob)entity, time);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel world, LivingEntity entity, long time) {
        this.start(world, (Mob)entity, time);
    }
}

