/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class SetEntityLookTarget {
    public static BehaviorControl<LivingEntity> create(MobCategory spawnGroup, float maxDistance) {
        return SetEntityLookTarget.create((LivingEntity entity) -> spawnGroup.equals(entity.getType().getCategory()), maxDistance);
    }

    public static OneShot<LivingEntity> create(EntityType<?> type, float maxDistance) {
        return SetEntityLookTarget.create((LivingEntity entity) -> type.equals(entity.getType()), maxDistance);
    }

    public static OneShot<LivingEntity> create(float maxDistance) {
        return SetEntityLookTarget.create((LivingEntity entity) -> true, maxDistance);
    }

    public static OneShot<LivingEntity> create(Predicate<LivingEntity> predicate, float maxDistance) {
        float f = maxDistance * maxDistance;
        return BehaviorBuilder.create(context -> context.group(context.absent(MemoryModuleType.LOOK_TARGET), context.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)context, (lookTarget, visibleMobs) -> (world, entity, time) -> {
            Optional<LivingEntity> optional = ((NearestVisibleLivingEntities)context.get(visibleMobs)).findClosest(predicate.and(target -> target.distanceToSqr(entity) <= (double)f && !entity.hasPassenger((Entity)target)));
            if (optional.isEmpty()) {
                return false;
            }
            lookTarget.set(new EntityTracker(optional.get(), true));
            return true;
        }));
    }
}

