/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class WolfVariants {
    public static final ResourceKey<WolfVariant> PALE = WolfVariants.createKey("pale");
    public static final ResourceKey<WolfVariant> SPOTTED = WolfVariants.createKey("spotted");
    public static final ResourceKey<WolfVariant> SNOWY = WolfVariants.createKey("snowy");
    public static final ResourceKey<WolfVariant> BLACK = WolfVariants.createKey("black");
    public static final ResourceKey<WolfVariant> ASHEN = WolfVariants.createKey("ashen");
    public static final ResourceKey<WolfVariant> RUSTY = WolfVariants.createKey("rusty");
    public static final ResourceKey<WolfVariant> WOODS = WolfVariants.createKey("woods");
    public static final ResourceKey<WolfVariant> CHESTNUT = WolfVariants.createKey("chestnut");
    public static final ResourceKey<WolfVariant> STRIPED = WolfVariants.createKey("striped");
    public static final ResourceKey<WolfVariant> DEFAULT = PALE;

    private static ResourceKey<WolfVariant> createKey(String id) {
        return ResourceKey.create(Registries.WOLF_VARIANT, ResourceLocation.withDefaultNamespace(id));
    }

    static void register(BootstrapContext<WolfVariant> registry, ResourceKey<WolfVariant> key, String textureName, ResourceKey<Biome> biome) {
        WolfVariants.register(registry, key, textureName, HolderSet.direct(registry.lookup(Registries.BIOME).getOrThrow(biome)));
    }

    static void register(BootstrapContext<WolfVariant> registry, ResourceKey<WolfVariant> key, String textureName, TagKey<Biome> biomeTag) {
        WolfVariants.register(registry, key, textureName, registry.lookup(Registries.BIOME).getOrThrow(biomeTag));
    }

    static void register(BootstrapContext<WolfVariant> registry, ResourceKey<WolfVariant> key, String textureName, HolderSet<Biome> biomes) {
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace("entity/wolf/" + textureName);
        ResourceLocation resourceLocation2 = ResourceLocation.withDefaultNamespace("entity/wolf/" + textureName + "_tame");
        ResourceLocation resourceLocation3 = ResourceLocation.withDefaultNamespace("entity/wolf/" + textureName + "_angry");
        registry.register(key, new WolfVariant(resourceLocation, resourceLocation2, resourceLocation3, biomes));
    }

    public static Holder<WolfVariant> getSpawnVariant(RegistryAccess dynamicRegistryManager, Holder<Biome> biome) {
        Registry<WolfVariant> registry = dynamicRegistryManager.registryOrThrow(Registries.WOLF_VARIANT);
        return registry.holders().filter(entry -> ((WolfVariant)entry.value()).biomes().contains(biome)).findFirst().or(() -> registry.getHolder(DEFAULT)).or(registry::getAny).orElseThrow();
    }

    public static void bootstrap(BootstrapContext<WolfVariant> registry) {
        WolfVariants.register(registry, PALE, "wolf", Biomes.TAIGA);
        WolfVariants.register(registry, SPOTTED, "wolf_spotted", BiomeTags.IS_SAVANNA);
        WolfVariants.register(registry, SNOWY, "wolf_snowy", Biomes.GROVE);
        WolfVariants.register(registry, BLACK, "wolf_black", Biomes.OLD_GROWTH_PINE_TAIGA);
        WolfVariants.register(registry, ASHEN, "wolf_ashen", Biomes.SNOWY_TAIGA);
        WolfVariants.register(registry, RUSTY, "wolf_rusty", BiomeTags.IS_JUNGLE);
        WolfVariants.register(registry, WOODS, "wolf_woods", Biomes.FOREST);
        WolfVariants.register(registry, CHESTNUT, "wolf_chestnut", Biomes.OLD_GROWTH_SPRUCE_TAIGA);
        WolfVariants.register(registry, STRIPED, "wolf_striped", BiomeTags.IS_BADLANDS);
    }
}

