/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.ItemStack;

public class EnderDragonPart
extends Entity {
    public final EnderDragon parentMob;
    public final String name;
    private final EntityDimensions size;

    public EnderDragonPart(EnderDragon owner, String name, float width, float height) {
        super(owner.getType(), owner.level());
        this.size = EntityDimensions.scalable(width, height);
        this.refreshDimensions();
        this.parentMob = owner;
        this.name = name;
    }

    @Override
    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
    }

    @Override
    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
    }

    @Override
    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    @Nullable
    @Override
    public ItemStack getPickResult() {
        return this.parentMob.getPickResult();
    }

    @Override
    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        return this.parentMob.hurt(this, source, amount);
    }

    @Override
    @Override
    public boolean is(Entity entity) {
        return this == entity || this.parentMob == entity;
    }

    @Override
    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Override
    public EntityDimensions getDimensions(Pose pose) {
        return this.size;
    }

    @Override
    @Override
    public boolean shouldBeSaved() {
        return false;
    }
}

