/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.windcharge;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.phys.Vec3;

public class WindCharge
extends AbstractWindCharge {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(true, false, Optional.of(Float.valueOf(1.22f)), BuiltInRegistries.BLOCK.getTag(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));
    private static final float RADIUS = 1.2f;
    private int noDeflectTicks = 5;

    public WindCharge(EntityType<? extends AbstractWindCharge> type, Level world) {
        super(type, world);
    }

    public WindCharge(Player player, Level world, double x, double y, double z) {
        super(EntityType.WIND_CHARGE, world, player, x, y, z);
    }

    public WindCharge(Level world, double x, double y, double z, Vec3 velocity) {
        super((EntityType<? extends AbstractWindCharge>)EntityType.WIND_CHARGE, x, y, z, velocity, world);
    }

    @Override
    @Override
    public void tick() {
        super.tick();
        if (this.noDeflectTicks > 0) {
            --this.noDeflectTicks;
        }
    }

    @Override
    @Override
    public boolean deflect(ProjectileDeflection deflection, @Nullable Entity deflector, @Nullable Entity owner, boolean fromAttack) {
        if (this.noDeflectTicks > 0) {
            return false;
        }
        return super.deflect(deflection, deflector, owner, fromAttack);
    }

    @Override
    @Override
    public void explode(Vec3 pos) {
        this.level().explode(this, null, EXPLOSION_DAMAGE_CALCULATOR, pos.x(), pos.y(), pos.z(), 1.2f, false, Level.ExplosionInteraction.TRIGGER, ParticleTypes.GUST_EMITTER_SMALL, ParticleTypes.GUST_EMITTER_LARGE, SoundEvents.WIND_CHARGE_BURST);
    }
}

