/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DismountHelper {
    public static int[][] offsetsForDirection(Direction movementDirection) {
        Direction direction = movementDirection.getClockWise();
        Direction direction2 = direction.getOpposite();
        Direction direction3 = movementDirection.getOpposite();
        return new int[][]{{direction.getStepX(), direction.getStepZ()}, {direction2.getStepX(), direction2.getStepZ()}, {direction3.getStepX() + direction.getStepX(), direction3.getStepZ() + direction.getStepZ()}, {direction3.getStepX() + direction2.getStepX(), direction3.getStepZ() + direction2.getStepZ()}, {movementDirection.getStepX() + direction.getStepX(), movementDirection.getStepZ() + direction.getStepZ()}, {movementDirection.getStepX() + direction2.getStepX(), movementDirection.getStepZ() + direction2.getStepZ()}, {direction3.getStepX(), direction3.getStepZ()}, {movementDirection.getStepX(), movementDirection.getStepZ()}};
    }

    public static boolean isBlockFloorValid(double height) {
        return !Double.isInfinite(height) && height < 1.0;
    }

    public static boolean canDismountTo(CollisionGetter world, LivingEntity entity, AABB targetBox) {
        Iterable<VoxelShape> iterable = world.getBlockCollisions(entity, targetBox);
        for (VoxelShape voxelShape : iterable) {
            if (voxelShape.isEmpty()) continue;
            return false;
        }
        return world.getWorldBorder().isWithinBounds(targetBox);
    }

    public static boolean canDismountTo(CollisionGetter world, Vec3 offset, LivingEntity entity, Pose pose) {
        return DismountHelper.canDismountTo(world, entity, entity.getLocalBoundsForPose(pose).move(offset));
    }

    public static VoxelShape nonClimbableShape(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        if (blockState.is(BlockTags.CLIMBABLE) || blockState.getBlock() instanceof TrapDoorBlock && blockState.getValue(TrapDoorBlock.OPEN).booleanValue()) {
            return Shapes.empty();
        }
        return blockState.getCollisionShape(world, pos);
    }

    public static double findCeilingFrom(BlockPos pos, int maxDistance, Function<BlockPos, VoxelShape> collisionShapeGetter) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (int i = 0; i < maxDistance; ++i) {
            VoxelShape voxelShape = collisionShapeGetter.apply(mutableBlockPos);
            if (!voxelShape.isEmpty()) {
                return (double)(pos.getY() + i) + voxelShape.min(Direction.Axis.Y);
            }
            mutableBlockPos.move(Direction.UP);
        }
        return Double.POSITIVE_INFINITY;
    }

    @Nullable
    public static Vec3 findSafeDismountLocation(EntityType<?> entityType, CollisionGetter world, BlockPos pos, boolean ignoreInvalidPos) {
        if (ignoreInvalidPos && entityType.isBlockDangerous(world.getBlockState(pos))) {
            return null;
        }
        double d = world.getBlockFloorHeight(DismountHelper.nonClimbableShape(world, pos), () -> DismountHelper.nonClimbableShape(world, pos.below()));
        if (!DismountHelper.isBlockFloorValid(d)) {
            return null;
        }
        if (ignoreInvalidPos && d <= 0.0 && entityType.isBlockDangerous(world.getBlockState(pos.below()))) {
            return null;
        }
        Vec3 vec3 = Vec3.upFromBottomCenterOf(pos, d);
        AABB aABB = entityType.getDimensions().makeBoundingBox(vec3);
        Iterable<VoxelShape> iterable = world.getBlockCollisions(null, aABB);
        for (VoxelShape voxelShape : iterable) {
            if (voxelShape.isEmpty()) continue;
            return null;
        }
        if (entityType == EntityType.PLAYER && (world.getBlockState(pos).is(BlockTags.INVALID_SPAWN_INSIDE) || world.getBlockState(pos.above()).is(BlockTags.INVALID_SPAWN_INSIDE))) {
            return null;
        }
        if (!world.getWorldBorder().isWithinBounds(aABB)) {
            return null;
        }
        return vec3;
    }
}

