/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;

public abstract class VehicleEntity
extends Entity {
    protected static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.FLOAT);

    public VehicleEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide && !this.isRemoved()) {
            boolean flag;
            if (this.isInvulnerableTo(source)) {
                return false;
            }
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            CraftEntity attacker = source.getEntity() == null ? null : source.getEntity().getBukkitEntity();
            VehicleDamageEvent event = new VehicleDamageEvent(vehicle, (org.bukkit.entity.Entity)attacker, (double)amount);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            amount = (float)event.getDamage();
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.markHurt();
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, source.getEntity());
            boolean bl = flag = source.getEntity() instanceof Player && ((Player)source.getEntity()).getAbilities().instabuild;
            if ((flag || this.getDamage() <= 40.0f) && !this.shouldSourceDestroy(source)) {
                if (flag) {
                    VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)attacker);
                    this.level().getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                    if (destroyEvent.isCancelled()) {
                        this.setDamage(40.0f);
                        return true;
                    }
                    this.discard(EntityRemoveEvent.Cause.DEATH);
                }
            } else {
                VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)attacker);
                this.level().getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                if (destroyEvent.isCancelled()) {
                    this.setDamage(40.0f);
                    return true;
                }
                this.destroy(source);
            }
            return true;
        }
        return true;
    }

    boolean shouldSourceDestroy(DamageSource source) {
        return false;
    }

    public void destroy(Item selfAsItem) {
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack itemstack = new ItemStack(selfAsItem);
            itemstack.set(DataComponents.CUSTOM_NAME, this.getCustomName());
            this.spawnAtLocation(itemstack);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ID_HURT, 0);
        builder.define(DATA_ID_HURTDIR, 1);
        builder.define(DATA_ID_DAMAGE, Float.valueOf(0.0f));
    }

    public void setHurtTime(int damageWobbleTicks) {
        this.entityData.set(DATA_ID_HURT, damageWobbleTicks);
    }

    public void setHurtDir(int damageWobbleSide) {
        this.entityData.set(DATA_ID_HURTDIR, damageWobbleSide);
    }

    public void setDamage(float damageWobbleStrength) {
        this.entityData.set(DATA_ID_DAMAGE, Float.valueOf(damageWobbleStrength));
    }

    public float getDamage() {
        return this.entityData.get(DATA_ID_DAMAGE).floatValue();
    }

    public int getHurtTime() {
        return this.entityData.get(DATA_ID_HURT);
    }

    public int getHurtDir() {
        return this.entityData.get(DATA_ID_HURTDIR);
    }

    protected void destroy(DamageSource source) {
        this.destroy(this.getDropItem());
    }

    abstract Item getDropItem();
}

