/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public interface Equipable {
    public EquipmentSlot getEquipmentSlot();

    default public Holder<SoundEvent> getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_GENERIC;
    }

    default public InteractionResultHolder<ItemStack> swapWithEquipmentSlot(Item item, Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        EquipmentSlot equipmentSlot = user.getEquipmentSlotForItem(itemStack);
        if (!user.canUseSlot(equipmentSlot)) {
            return InteractionResultHolder.pass(itemStack);
        }
        ItemStack itemStack2 = user.getItemBySlot(equipmentSlot);
        if (EnchantmentHelper.has(itemStack2, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && !user.isCreative() || ItemStack.matches(itemStack, itemStack2)) {
            return InteractionResultHolder.fail(itemStack);
        }
        if (!world.isClientSide()) {
            user.awardStat(Stats.ITEM_USED.get(item));
        }
        ItemStack itemStack3 = itemStack2.isEmpty() ? itemStack : itemStack2.copyAndClear();
        ItemStack itemStack4 = user.isCreative() ? itemStack.copy() : itemStack.copyAndClear();
        user.setItemSlot(equipmentSlot, itemStack4);
        return InteractionResultHolder.sidedSuccess(itemStack3, world.isClientSide());
    }

    @Nullable
    public static Equipable get(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.getItem();
        if (item instanceof Equipable) {
            Equipable equipable = (Equipable)((Object)item);
            return equipable;
        }
        FeatureElement featureElement = stack.getItem();
        if (featureElement instanceof BlockItem && (featureElement = (blockItem = (BlockItem)featureElement).getBlock()) instanceof Equipable) {
            Equipable equipable2 = (Equipable)((Object)featureElement);
            return equipable2;
        }
        return null;
    }
}

