/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import io.papermc.paper.event.player.PlayerItemCooldownEvent;
import net.minecraft.network.protocol.game.ClientboundCooldownPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.entity.Player;

public class ServerItemCooldowns
extends ItemCooldowns {
    private final ServerPlayer player;

    public ServerItemCooldowns(ServerPlayer player) {
        this.player = player;
    }

    @Override
    public void addCooldown(Item item, int duration) {
        PlayerItemCooldownEvent event = new PlayerItemCooldownEvent((Player)this.player.getBukkitEntity(), CraftItemType.minecraftToBukkit(item), duration);
        if (event.callEvent()) {
            super.addCooldown(item, event.getCooldown());
        }
    }

    @Override
    protected void onCooldownStarted(Item item, int duration) {
        super.onCooldownStarted(item, duration);
        this.player.connection.send(new ClientboundCooldownPacket(item, duration));
    }

    @Override
    protected void onCooldownEnded(Item item) {
        super.onCooldownEnded(item);
        this.player.connection.send(new ClientboundCooldownPacket(item, 0));
    }
}

