/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.inventory.recipe.RecipeBookExactChoiceRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftRecipe;
import org.bukkit.craftbukkit.inventory.CraftShapedRecipe;
import org.bukkit.inventory.RecipeChoice;

public class ShapedRecipe
extends RecipeBookExactChoiceRecipe<CraftingInput>
implements CraftingRecipe {
    final ShapedRecipePattern pattern;
    final ItemStack result;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;

    public ShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern raw, ItemStack result, boolean showNotification) {
        this.group = group;
        this.category = category;
        this.pattern = raw;
        this.result = result;
        this.showNotification = showNotification;
        this.checkExactIngredients();
    }

    public ShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern raw, ItemStack result) {
        this(group, category, raw, result, true);
    }

    public org.bukkit.inventory.ShapedRecipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.result);
        CraftShapedRecipe recipe = new CraftShapedRecipe(id, result, this);
        recipe.setGroup(this.group);
        recipe.setCategory(CraftRecipe.getCategory(this.category()));
        block0 : switch (this.pattern.height()) {
            case 1: {
                switch (this.pattern.width()) {
                    case 1: {
                        recipe.shape(new String[]{"a"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc"});
                    }
                }
                break;
            }
            case 2: {
                switch (this.pattern.width()) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def"});
                    }
                }
                break;
            }
            case 3: {
                switch (this.pattern.width()) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b", "c"});
                        break block0;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd", "ef"});
                        break block0;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def", "ghi"});
                    }
                }
            }
        }
        char c = 'a';
        for (Ingredient list : this.pattern.ingredients()) {
            RecipeChoice choice = CraftRecipe.toBukkit(list);
            if (choice != RecipeChoice.empty()) {
                recipe.setIngredient(c, choice);
            }
            c = (char)(c + 1);
        }
        return recipe;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHAPED_RECIPE;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider registriesLookup) {
        return this.result;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    @Override
    public boolean showNotification() {
        return this.showNotification;
    }

    @Override
    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.pattern.width() && height >= this.pattern.height();
    }

    @Override
    public boolean matches(CraftingInput input, Level world) {
        return this.pattern.matches(input);
    }

    @Override
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider lookup) {
        return this.getResultItem(lookup).copy();
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    @Override
    public boolean isIncomplete() {
        NonNullList<Ingredient> nonnulllist = this.getIngredients();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(recipeitemstack -> !recipeitemstack.isEmpty()).anyMatch(recipeitemstack -> recipeitemstack.getItems().length == 0);
    }

    public static class Serializer
    implements RecipeSerializer<ShapedRecipe> {
        public static final MapCodec<ShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapedrecipes -> shapedrecipes.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(shapedrecipes -> shapedrecipes.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(shapedrecipes -> shapedrecipes.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(shapedrecipes -> shapedrecipes.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(shapedrecipes -> shapedrecipes.showNotification)).apply((Applicative)instance, ShapedRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Override
        public MapCodec<ShapedRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ShapedRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            String s = buf.readUtf();
            CraftingBookCategory craftingbookcategory = buf.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode(buf);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            boolean flag = buf.readBoolean();
            return new ShapedRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, ShapedRecipe recipe) {
            buf.writeUtf(recipe.group);
            buf.writeEnum(recipe.category);
            ShapedRecipePattern.STREAM_CODEC.encode(buf, recipe.pattern);
            ItemStack.STREAM_CODEC.encode(buf, recipe.result);
            buf.writeBoolean(recipe.showNotification);
        }
    }
}

