/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;

public final class Enchantment
extends Record {
    private final Component description;
    public final EnchantmentDefinition definition;
    private final HolderSet<Enchantment> exclusiveSet;
    private final DataComponentMap effects;
    public static final int MAX_LEVEL = 255;
    public static final Codec<Enchantment> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("description").forGetter(Enchantment::description), (App)EnchantmentDefinition.CODEC.forGetter(Enchantment::definition), (App)RegistryCodecs.homogeneousList(Registries.ENCHANTMENT).optionalFieldOf("exclusive_set", HolderSet.direct(new Holder[0])).forGetter(Enchantment::exclusiveSet), (App)EnchantmentEffectComponents.CODEC.optionalFieldOf("effects", (Object)DataComponentMap.EMPTY).forGetter(Enchantment::effects)).apply((Applicative)instance, Enchantment::new));
    public static final Codec<Holder<Enchantment>> CODEC = RegistryFixedCodec.create(Registries.ENCHANTMENT);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Enchantment>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.ENCHANTMENT);

    public Enchantment(Component component, EnchantmentDefinition enchantmentDefinition, HolderSet<Enchantment> holderSet, DataComponentMap dataComponentMap) {
        this.description = component;
        this.definition = enchantmentDefinition;
        this.exclusiveSet = holderSet;
        this.effects = dataComponentMap;
    }

    public static Cost constantCost(int base) {
        return new Cost(base, 0);
    }

    public static Cost dynamicCost(int base, int perLevel) {
        return new Cost(base, perLevel);
    }

    public static EnchantmentDefinition definition(HolderSet<Item> supportedItems, HolderSet<Item> primaryItems, int weight, int maxLevel, Cost minCost, Cost maxCost, int anvilCost, EquipmentSlotGroup ... slots) {
        return new EnchantmentDefinition(supportedItems, Optional.of(primaryItems), weight, maxLevel, minCost, maxCost, anvilCost, List.of(slots));
    }

    public static EnchantmentDefinition definition(HolderSet<Item> supportedItems, int weight, int maxLevel, Cost minCost, Cost maxCost, int anvilCost, EquipmentSlotGroup ... slots) {
        return new EnchantmentDefinition(supportedItems, Optional.empty(), weight, maxLevel, minCost, maxCost, anvilCost, List.of(slots));
    }

    public Map<EquipmentSlot, ItemStack> getSlotItems(LivingEntity entity) {
        EnumMap map = Maps.newEnumMap(EquipmentSlot.class);
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack;
            if (!this.matchingSlot(equipmentSlot) || (itemStack = entity.getItemBySlot(equipmentSlot)).isEmpty()) continue;
            map.put(equipmentSlot, itemStack);
        }
        return map;
    }

    public HolderSet<Item> getSupportedItems() {
        return this.definition.supportedItems();
    }

    public boolean matchingSlot(EquipmentSlot slot) {
        return this.definition.slots().stream().anyMatch(slotx -> slotx.test(slot));
    }

    public boolean isPrimaryItem(ItemStack stack) {
        return this.isSupportedItem(stack) && (this.definition.primaryItems.isEmpty() || stack.is(this.definition.primaryItems.get()));
    }

    public boolean isSupportedItem(ItemStack stack) {
        return stack.is(this.definition.supportedItems);
    }

    public int getWeight() {
        return this.definition.weight();
    }

    public int getAnvilCost() {
        return this.definition.anvilCost();
    }

    public int getMinLevel() {
        return 1;
    }

    public int getMaxLevel() {
        return this.definition.maxLevel();
    }

    public int getMinCost(int level) {
        return this.definition.minCost().calculate(level);
    }

    public int getMaxCost(int level) {
        return this.definition.maxCost().calculate(level);
    }

    @Override
    @Override
    public String toString() {
        return "Enchantment " + this.description.getString();
    }

    public static boolean areCompatible(Holder<Enchantment> first, Holder<Enchantment> second) {
        return !first.equals(second) && !first.value().exclusiveSet.contains(second) && !second.value().exclusiveSet.contains(first);
    }

    public static Component getFullname(Holder<Enchantment> enchantment, int level) {
        MutableComponent mutableComponent = enchantment.value().description.copy();
        if (enchantment.is(EnchantmentTags.CURSE)) {
            ComponentUtils.mergeStyles(mutableComponent, Style.EMPTY.withColor(ChatFormatting.RED));
        } else {
            ComponentUtils.mergeStyles(mutableComponent, Style.EMPTY.withColor(ChatFormatting.GRAY));
        }
        if (level != 1 || enchantment.value().getMaxLevel() != 1) {
            mutableComponent.append(CommonComponents.SPACE).append(Component.translatable("enchantment.level." + level));
        }
        return mutableComponent;
    }

    public boolean canEnchant(ItemStack stack) {
        return this.definition.supportedItems().contains(stack.getItemHolder());
    }

    public <T> List<T> getEffects(DataComponentType<List<T>> type) {
        return this.effects.getOrDefault(type, List.of());
    }

    public boolean isImmuneToDamage(ServerLevel world, int level, Entity user, DamageSource damageSource) {
        LootContext lootContext = Enchantment.damageContext(world, level, user, damageSource);
        for (ConditionalEffect conditionalEffect : this.getEffects(EnchantmentEffectComponents.DAMAGE_IMMUNITY)) {
            if (!conditionalEffect.matches(lootContext)) continue;
            return true;
        }
        return false;
    }

    public void modifyDamageProtection(ServerLevel world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat damageProtection) {
        LootContext lootContext = Enchantment.damageContext(world, level, user, damageSource);
        for (ConditionalEffect conditionalEffect : this.getEffects(EnchantmentEffectComponents.DAMAGE_PROTECTION)) {
            if (!conditionalEffect.matches(lootContext)) continue;
            damageProtection.setValue(((EnchantmentValueEffect)conditionalEffect.effect()).process(level, user.getRandom(), damageProtection.floatValue()));
        }
    }

    public void modifyDurabilityChange(ServerLevel world, int level, ItemStack stack, MutableFloat itemDamage) {
        this.modifyItemFilteredCount(EnchantmentEffectComponents.ITEM_DAMAGE, world, level, stack, itemDamage);
    }

    public void modifyAmmoCount(ServerLevel world, int level, ItemStack projectileStack, MutableFloat ammoUse) {
        this.modifyItemFilteredCount(EnchantmentEffectComponents.AMMO_USE, world, level, projectileStack, ammoUse);
    }

    public void modifyPiercingCount(ServerLevel world, int level, ItemStack stack, MutableFloat projectilePiercing) {
        this.modifyItemFilteredCount(EnchantmentEffectComponents.PROJECTILE_PIERCING, world, level, stack, projectilePiercing);
    }

    public void modifyBlockExperience(ServerLevel world, int level, ItemStack stack, MutableFloat blockExperience) {
        this.modifyItemFilteredCount(EnchantmentEffectComponents.BLOCK_EXPERIENCE, world, level, stack, blockExperience);
    }

    public void modifyMobExperience(ServerLevel world, int level, ItemStack stack, Entity user, MutableFloat mobExperience) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.MOB_EXPERIENCE, world, level, stack, user, mobExperience);
    }

    public void modifyDurabilityToRepairFromXp(ServerLevel world, int level, ItemStack stack, MutableFloat repairWithXp) {
        this.modifyItemFilteredCount(EnchantmentEffectComponents.REPAIR_WITH_XP, world, level, stack, repairWithXp);
    }

    public void modifyTridentReturnToOwnerAcceleration(ServerLevel world, int level, ItemStack stack, Entity user, MutableFloat tridentReturnAcceleration) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.TRIDENT_RETURN_ACCELERATION, world, level, stack, user, tridentReturnAcceleration);
    }

    public void modifyTridentSpinAttackStrength(RandomSource random, int level, MutableFloat tridentSpinAttackStrength) {
        this.modifyUnfilteredValue(EnchantmentEffectComponents.TRIDENT_SPIN_ATTACK_STRENGTH, random, level, tridentSpinAttackStrength);
    }

    public void modifyFishingTimeReduction(ServerLevel world, int level, ItemStack stack, Entity user, MutableFloat fishingTimeReduction) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.FISHING_TIME_REDUCTION, world, level, stack, user, fishingTimeReduction);
    }

    public void modifyFishingLuckBonus(ServerLevel world, int level, ItemStack stack, Entity user, MutableFloat fishingLuckBonus) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.FISHING_LUCK_BONUS, world, level, stack, user, fishingLuckBonus);
    }

    public void modifyDamage(ServerLevel world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat damage) {
        this.modifyDamageFilteredValue(EnchantmentEffectComponents.DAMAGE, world, level, stack, user, damageSource, damage);
    }

    public void modifyFallBasedDamage(ServerLevel world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat smashDamagePerFallenBlock) {
        this.modifyDamageFilteredValue(EnchantmentEffectComponents.SMASH_DAMAGE_PER_FALLEN_BLOCK, world, level, stack, user, damageSource, smashDamagePerFallenBlock);
    }

    public void modifyKnockback(ServerLevel world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat knockback) {
        this.modifyDamageFilteredValue(EnchantmentEffectComponents.KNOCKBACK, world, level, stack, user, damageSource, knockback);
    }

    public void modifyArmorEffectivness(ServerLevel world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat armorEffectiveness) {
        this.modifyDamageFilteredValue(EnchantmentEffectComponents.ARMOR_EFFECTIVENESS, world, level, stack, user, damageSource, armorEffectiveness);
    }

    public static void doPostAttack(TargetedConditionalEffect<EnchantmentEntityEffect> effect, ServerLevel world, int level, EnchantedItemInUse context, Entity user, DamageSource damageSource) {
        if (effect.matches(Enchantment.damageContext(world, level, user, damageSource))) {
            Entity entity;
            switch (effect.affected()) {
                default: {
                    throw new MatchException(null, null);
                }
                case ATTACKER: {
                    Entity entity2 = damageSource.getEntity();
                    break;
                }
                case DAMAGING_ENTITY: {
                    Entity entity2 = damageSource.getDirectEntity();
                    break;
                }
                case VICTIM: {
                    Entity entity2 = entity = user;
                }
            }
            if (entity != null) {
                effect.effect().apply(world, level, context, entity, entity.position());
            }
        }
    }

    public void doPostAttack(ServerLevel world, int level, EnchantedItemInUse context, EnchantmentTarget target, Entity user, DamageSource damageSource) {
        for (TargetedConditionalEffect targetedConditionalEffect : this.getEffects(EnchantmentEffectComponents.POST_ATTACK)) {
            if (target != targetedConditionalEffect.enchanted()) continue;
            Enchantment.doPostAttack(targetedConditionalEffect, world, level, context, user, damageSource);
        }
    }

    public void modifyProjectileCount(ServerLevel world, int level, ItemStack stack, Entity user, MutableFloat projectileCount) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.PROJECTILE_COUNT, world, level, stack, user, projectileCount);
    }

    public void modifyProjectileSpread(ServerLevel world, int level, ItemStack stack, Entity user, MutableFloat projectileSpread) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.PROJECTILE_SPREAD, world, level, stack, user, projectileSpread);
    }

    public void modifyCrossbowChargeTime(RandomSource random, int level, MutableFloat crossbowChargeTime) {
        this.modifyUnfilteredValue(EnchantmentEffectComponents.CROSSBOW_CHARGE_TIME, random, level, crossbowChargeTime);
    }

    public void modifyUnfilteredValue(DataComponentType<EnchantmentValueEffect> type, RandomSource random, int level, MutableFloat value) {
        EnchantmentValueEffect enchantmentValueEffect = this.effects.get(type);
        if (enchantmentValueEffect != null) {
            value.setValue(enchantmentValueEffect.process(level, random, value.floatValue()));
        }
    }

    public void tick(ServerLevel world, int level, EnchantedItemInUse context, Entity user) {
        Enchantment.applyEffects(this.getEffects(EnchantmentEffectComponents.TICK), Enchantment.entityContext(world, level, user, user.position()), effect -> effect.apply(world, level, context, user, user.position()));
    }

    public void onProjectileSpawned(ServerLevel world, int level, EnchantedItemInUse context, Entity user) {
        Enchantment.applyEffects(this.getEffects(EnchantmentEffectComponents.PROJECTILE_SPAWNED), Enchantment.entityContext(world, level, user, user.position()), effect -> effect.apply(world, level, context, user, user.position()));
    }

    public void onHitBlock(ServerLevel world, int level, EnchantedItemInUse context, Entity enchantedEntity, Vec3 pos, BlockState state) {
        Enchantment.applyEffects(this.getEffects(EnchantmentEffectComponents.HIT_BLOCK), Enchantment.blockHitContext(world, level, enchantedEntity, pos, state), effect -> effect.apply(world, level, context, enchantedEntity, pos));
    }

    private void modifyItemFilteredCount(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> type, ServerLevel world, int level, ItemStack stack, MutableFloat value) {
        Enchantment.applyEffects(this.getEffects(type), Enchantment.itemContext(world, level, stack), effect -> value.setValue(effect.process(level, world.getRandom(), value.getValue().floatValue())));
    }

    private void modifyEntityFilteredValue(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> type, ServerLevel world, int level, ItemStack stack, Entity user, MutableFloat value) {
        Enchantment.applyEffects(this.getEffects(type), Enchantment.entityContext(world, level, user, user.position()), effect -> value.setValue(effect.process(level, user.getRandom(), value.floatValue())));
    }

    private void modifyDamageFilteredValue(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> type, ServerLevel world, int level, ItemStack stack, Entity user, DamageSource damageSource, MutableFloat value) {
        Enchantment.applyEffects(this.getEffects(type), Enchantment.damageContext(world, level, user, damageSource), effect -> value.setValue(effect.process(level, user.getRandom(), value.floatValue())));
    }

    public static LootContext damageContext(ServerLevel world, int level, Entity entity, DamageSource damageSource) {
        LootParams lootParams = new LootParams.Builder(world).withParameter(LootContextParams.THIS_ENTITY, entity).withParameter(LootContextParams.ENCHANTMENT_LEVEL, level).withParameter(LootContextParams.ORIGIN, entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, damageSource.getDirectEntity()).create(LootContextParamSets.ENCHANTED_DAMAGE);
        return new LootContext.Builder(lootParams).create(Optional.empty());
    }

    private static LootContext itemContext(ServerLevel world, int level, ItemStack stack) {
        LootParams lootParams = new LootParams.Builder(world).withParameter(LootContextParams.TOOL, stack).withParameter(LootContextParams.ENCHANTMENT_LEVEL, level).create(LootContextParamSets.ENCHANTED_ITEM);
        return new LootContext.Builder(lootParams).create(Optional.empty());
    }

    private static LootContext locationContext(ServerLevel world, int level, Entity entity, boolean enchantmentActive) {
        LootParams lootParams = new LootParams.Builder(world).withParameter(LootContextParams.THIS_ENTITY, entity).withParameter(LootContextParams.ENCHANTMENT_LEVEL, level).withParameter(LootContextParams.ORIGIN, entity.position()).withParameter(LootContextParams.ENCHANTMENT_ACTIVE, enchantmentActive).create(LootContextParamSets.ENCHANTED_LOCATION);
        return new LootContext.Builder(lootParams).create(Optional.empty());
    }

    private static LootContext entityContext(ServerLevel world, int level, Entity entity, Vec3 pos) {
        LootParams lootParams = new LootParams.Builder(world).withParameter(LootContextParams.THIS_ENTITY, entity).withParameter(LootContextParams.ENCHANTMENT_LEVEL, level).withParameter(LootContextParams.ORIGIN, pos).create(LootContextParamSets.ENCHANTED_ENTITY);
        return new LootContext.Builder(lootParams).create(Optional.empty());
    }

    private static LootContext blockHitContext(ServerLevel world, int level, Entity entity, Vec3 pos, BlockState state) {
        LootParams lootParams = new LootParams.Builder(world).withParameter(LootContextParams.THIS_ENTITY, entity).withParameter(LootContextParams.ENCHANTMENT_LEVEL, level).withParameter(LootContextParams.ORIGIN, pos).withParameter(LootContextParams.BLOCK_STATE, state).create(LootContextParamSets.HIT_BLOCK);
        return new LootContext.Builder(lootParams).create(Optional.empty());
    }

    private static <T> void applyEffects(List<ConditionalEffect<T>> entries, LootContext lootContext, Consumer<T> effectConsumer) {
        for (ConditionalEffect<T> conditionalEffect : entries) {
            if (!conditionalEffect.matches(lootContext)) continue;
            effectConsumer.accept(conditionalEffect.effect());
        }
    }

    public void runLocationChangedEffects(ServerLevel world, int level, EnchantedItemInUse context, LivingEntity user) {
        if (context.inSlot() != null && !this.matchingSlot(context.inSlot())) {
            Set<EnchantmentLocationBasedEffect> set = user.activeLocationDependentEnchantments().remove(this);
            if (set != null) {
                set.forEach(effect -> effect.onDeactivated(context, user, user.position(), level));
            }
            return;
        }
        ObjectArraySet set2 = user.activeLocationDependentEnchantments().get(this);
        for (ConditionalEffect conditionalEffect : this.getEffects(EnchantmentEffectComponents.LOCATION_CHANGED)) {
            boolean bl;
            EnchantmentLocationBasedEffect enchantmentLocationBasedEffect = (EnchantmentLocationBasedEffect)conditionalEffect.effect();
            boolean bl2 = bl = set2 != null && set2.contains(enchantmentLocationBasedEffect);
            if (conditionalEffect.matches(Enchantment.locationContext(world, level, user, bl))) {
                if (!bl) {
                    if (set2 == null) {
                        set2 = new ObjectArraySet();
                        user.activeLocationDependentEnchantments().put(this, (Set<EnchantmentLocationBasedEffect>)set2);
                    }
                    set2.add((EnchantmentLocationBasedEffect)enchantmentLocationBasedEffect);
                }
                enchantmentLocationBasedEffect.onChangedBlock(world, level, context, user, user.position(), !bl);
                continue;
            }
            if (set2 == null || !set2.remove(enchantmentLocationBasedEffect)) continue;
            enchantmentLocationBasedEffect.onDeactivated(context, user, user.position(), level);
        }
        if (set2 != null && set2.isEmpty()) {
            user.activeLocationDependentEnchantments().remove(this);
        }
    }

    public void stopLocationBasedEffects(int level, EnchantedItemInUse context, LivingEntity user) {
        Set<EnchantmentLocationBasedEffect> set = user.activeLocationDependentEnchantments().remove(this);
        if (set == null) {
            return;
        }
        for (EnchantmentLocationBasedEffect enchantmentLocationBasedEffect : set) {
            enchantmentLocationBasedEffect.onDeactivated(context, user, user.position(), level);
        }
    }

    public static Builder enchantment(EnchantmentDefinition definition) {
        return new Builder(definition);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Enchantment.class, "description;definition;exclusiveSet;effects", "description", "definition", "exclusiveSet", "effects"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Enchantment.class, "description;definition;exclusiveSet;effects", "description", "definition", "exclusiveSet", "effects"}, this, object);
    }

    public Component description() {
        return this.description;
    }

    public EnchantmentDefinition definition() {
        return this.definition;
    }

    public HolderSet<Enchantment> exclusiveSet() {
        return this.exclusiveSet;
    }

    public DataComponentMap effects() {
        return this.effects;
    }

    public record EnchantmentDefinition(HolderSet<Item> supportedItems, Optional<HolderSet<Item>> primaryItems, int weight, int maxLevel, Cost minCost, Cost maxCost, int anvilCost, List<EquipmentSlotGroup> slots) {
        public static final MapCodec<EnchantmentDefinition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList(Registries.ITEM).fieldOf("supported_items").forGetter(EnchantmentDefinition::supportedItems), (App)RegistryCodecs.homogeneousList(Registries.ITEM).optionalFieldOf("primary_items").forGetter(EnchantmentDefinition::primaryItems), (App)ExtraCodecs.intRange(1, 1024).fieldOf("weight").forGetter(EnchantmentDefinition::weight), (App)ExtraCodecs.intRange(1, 255).fieldOf("max_level").forGetter(EnchantmentDefinition::maxLevel), (App)Cost.CODEC.fieldOf("min_cost").forGetter(EnchantmentDefinition::minCost), (App)Cost.CODEC.fieldOf("max_cost").forGetter(EnchantmentDefinition::maxCost), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("anvil_cost").forGetter(EnchantmentDefinition::anvilCost), (App)EquipmentSlotGroup.CODEC.listOf().fieldOf("slots").forGetter(EnchantmentDefinition::slots)).apply((Applicative)instance, EnchantmentDefinition::new));
    }

    public record Cost(int base, int perLevelAboveFirst) {
        public static final Codec<Cost> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("base").forGetter(Cost::base), (App)Codec.INT.fieldOf("per_level_above_first").forGetter(Cost::perLevelAboveFirst)).apply((Applicative)instance, Cost::new));

        public int calculate(int level) {
            return this.base + this.perLevelAboveFirst * (level - 1);
        }
    }

    public static class Builder {
        private final EnchantmentDefinition definition;
        private HolderSet<Enchantment> exclusiveSet = HolderSet.direct(new Holder[0]);
        private final Map<DataComponentType<?>, List<?>> effectLists = new HashMap();
        private final DataComponentMap.Builder effectMapBuilder = DataComponentMap.builder();

        public Builder(EnchantmentDefinition properties) {
            this.definition = properties;
        }

        public Builder exclusiveWith(HolderSet<Enchantment> exclusiveSet) {
            this.exclusiveSet = exclusiveSet;
            return this;
        }

        public <E> Builder withEffect(DataComponentType<List<ConditionalEffect<E>>> effectType, E effect, LootItemCondition.Builder requirements) {
            this.getEffectsList(effectType).add(new ConditionalEffect<E>(effect, Optional.of(requirements.build())));
            return this;
        }

        public <E> Builder withEffect(DataComponentType<List<ConditionalEffect<E>>> effectType, E effect) {
            this.getEffectsList(effectType).add(new ConditionalEffect<E>(effect, Optional.empty()));
            return this;
        }

        public <E> Builder withEffect(DataComponentType<List<TargetedConditionalEffect<E>>> type, EnchantmentTarget enchanted, EnchantmentTarget affected, E effect, LootItemCondition.Builder requirements) {
            this.getEffectsList(type).add(new TargetedConditionalEffect<E>(enchanted, affected, effect, Optional.of(requirements.build())));
            return this;
        }

        public <E> Builder withEffect(DataComponentType<List<TargetedConditionalEffect<E>>> type, EnchantmentTarget enchanted, EnchantmentTarget affected, E effect) {
            this.getEffectsList(type).add(new TargetedConditionalEffect<E>(enchanted, affected, effect, Optional.empty()));
            return this;
        }

        public Builder withEffect(DataComponentType<List<EnchantmentAttributeEffect>> type, EnchantmentAttributeEffect effect) {
            this.getEffectsList(type).add(effect);
            return this;
        }

        public <E> Builder withSpecialEffect(DataComponentType<E> type, E effect) {
            this.effectMapBuilder.set(type, effect);
            return this;
        }

        public Builder withEffect(DataComponentType<Unit> type) {
            this.effectMapBuilder.set(type, Unit.INSTANCE);
            return this;
        }

        private <E> List<E> getEffectsList(DataComponentType<List<E>> type2) {
            return this.effectLists.computeIfAbsent(type2, type -> {
                ArrayList arrayList = new ArrayList();
                this.effectMapBuilder.set(type2, arrayList);
                return arrayList;
            });
        }

        public Enchantment build(ResourceLocation id) {
            return new Enchantment(Component.translatable(Util.makeDescriptionId("enchantment", id)), this.definition, this.exclusiveSet, this.effectMapBuilder.build());
        }
    }
}

