/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import io.papermc.paper.event.player.PlayerPurchaseEvent;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.bukkit.craftbukkit.inventory.CraftMerchant;

public interface Merchant {
    public void setTradingPlayer(@Nullable Player var1);

    @Nullable
    public Player getTradingPlayer();

    public MerchantOffers getOffers();

    public void overrideOffers(MerchantOffers var1);

    default public void processTrade(MerchantOffer merchantRecipe, @Nullable PlayerPurchaseEvent event) {
        this.notifyTrade(merchantRecipe);
    }

    public void notifyTrade(MerchantOffer var1);

    public void notifyTradeUpdated(ItemStack var1);

    public int getVillagerXp();

    public void overrideXp(int var1);

    public boolean showProgressBar();

    public SoundEvent getNotifyTradeSound();

    default public boolean canRestock() {
        return false;
    }

    default public void openTradingScreen(Player player, Component name, int levelProgress) {
        MerchantOffers merchantrecipelist;
        OptionalInt optionalint = player.openMenu(new SimpleMenuProvider((j, playerinventory, entityhuman1) -> new MerchantMenu(j, playerinventory, this), name));
        if (optionalint.isPresent() && !(merchantrecipelist = this.getOffers()).isEmpty()) {
            player.sendMerchantOffers(optionalint.getAsInt(), merchantrecipelist, levelProgress, this.getVillagerXp(), this.showProgressBar(), this.canRestock());
        }
    }

    public boolean isClientSide();

    public CraftMerchant getCraftMerchant();
}

