/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.ExplosionBlockCache;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private static final int MAX_DROPS_PER_COMBINED_STACK = 16;
    private final boolean fire;
    private final BlockInteraction blockInteraction;
    private final RandomSource random = RandomSource.create();
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    public final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final ParticleOptions smallExplosionParticles;
    private final ParticleOptions largeExplosionParticles;
    private final Holder<SoundEvent> explosionSound;
    private final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    private final Map<Player, Vec3> hitPlayers = Maps.newHashMap();
    public boolean wasCanceled = false;
    public float yield;
    private static final double[] CACHED_RAYS;
    private static final int CHUNK_CACHE_SHIFT = 2;
    private static final int CHUNK_CACHE_MASK = 3;
    private static final int CHUNK_CACHE_WIDTH = 4;
    private static final int BLOCK_EXPLOSION_CACHE_SHIFT = 3;
    private static final int BLOCK_EXPLOSION_CACHE_MASK = 7;
    private static final int BLOCK_EXPLOSION_CACHE_WIDTH = 8;
    private static final Float ZERO_RESISTANCE;
    private Long2ObjectOpenHashMap<ExplosionBlockCache> blockCache = null;
    private long[] chunkPosCache = null;
    private LevelChunk[] chunkCache = null;

    private ExplosionBlockCache getOrCacheExplosionBlock(int x, int y, int z, long key, boolean calculateResistance) {
        ExplosionBlockCache ret = (ExplosionBlockCache)this.blockCache.get(key);
        if (ret != null) {
            return ret;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (!this.level.isInWorldBounds(pos)) {
            ret = new ExplosionBlockCache(key, pos, null, null, 0.0f, true);
        } else {
            LevelChunk chunk;
            int chunkCacheKey = x >> 4 & 3 | z >> 4 << 2 & 0xC;
            long chunkKey = CoordinateUtils.getChunkKey(x >> 4, z >> 4);
            if (this.chunkPosCache[chunkCacheKey] == chunkKey) {
                chunk = this.chunkCache[chunkCacheKey];
            } else {
                this.chunkPosCache[chunkCacheKey] = chunkKey;
                this.chunkCache[chunkCacheKey] = chunk = this.level.getChunk(x >> 4, z >> 4);
            }
            BlockState blockState = chunk.moonrise$getBlock(x, y, z);
            FluidState fluidState = blockState.getFluidState();
            Optional<Float> resistance = !calculateResistance ? Optional.empty() : this.damageCalculator.getBlockExplosionResistance(this, this.level, pos, blockState, fluidState);
            ret = new ExplosionBlockCache(key, pos, blockState, fluidState, (resistance.orElse(ZERO_RESISTANCE).floatValue() + 0.3f) * 0.3f, false);
        }
        this.blockCache.put(key, (Object)ret);
        return ret;
    }

    private boolean clipsAnything(Vec3 from, Vec3 to, CollisionUtil.LazyEntityCollisionContext context, ExplosionBlockCache[] blockCache, BlockPos.MutableBlockPos currPos) {
        double adjX = 1.0E-7 * (from.x - to.x);
        double adjY = 1.0E-7 * (from.y - to.y);
        double adjZ = 1.0E-7 * (from.z - to.z);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return false;
        }
        double toXAdj = to.x - adjX;
        double toYAdj = to.y - adjY;
        double toZAdj = to.z - adjZ;
        double fromXAdj = from.x + adjX;
        double fromYAdj = from.y + adjY;
        double fromZAdj = from.z + adjZ;
        int currX = Mth.floor(fromXAdj);
        int currY = Mth.floor(fromYAdj);
        int currZ = Mth.floor(fromZAdj);
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - Mth.frac(fromXAdj) : Mth.frac(fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - Mth.frac(fromYAdj) : Mth.frac(fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - Mth.frac(fromZAdj) : Mth.frac(fromZAdj));
        while (true) {
            BlockState blockState;
            currPos.set(currX, currY, currZ);
            long key = BlockPos.asLong(currX, currY, currZ);
            int cacheKey = currX & 7 | (currY & 7) << 3 | (currZ & 7) << 6;
            ExplosionBlockCache cachedBlock = blockCache[cacheKey];
            if (cachedBlock == null || cachedBlock.key != key) {
                blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(currX, currY, currZ, key, false);
            }
            if ((blockState = cachedBlock.blockState) != null && !blockState.moonrise$emptyCollisionShape()) {
                VoxelShape collision = cachedBlock.cachedCollisionShape;
                if (collision == null) {
                    collision = blockState.moonrise$getConstantCollisionShape();
                    if (collision == null) {
                        collision = blockState.getCollisionShape(this.level, currPos, context);
                        if (!context.isDelegated()) {
                            cachedBlock.cachedCollisionShape = collision;
                        }
                    } else {
                        cachedBlock.cachedCollisionShape = collision;
                    }
                }
                if (!collision.isEmpty() && collision.clip(from, to, currPos) != null) {
                    return true;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return false;
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    private float getSeenFraction(Vec3 source, Entity target, ExplosionBlockCache[] blockCache, BlockPos.MutableBlockPos blockPos) {
        AABB boundingBox = target.getBoundingBox();
        double diffX = boundingBox.maxX - boundingBox.minX;
        double diffY = boundingBox.maxY - boundingBox.minY;
        double diffZ = boundingBox.maxZ - boundingBox.minZ;
        double incX = 1.0 / (diffX * 2.0 + 1.0);
        double incY = 1.0 / (diffY * 2.0 + 1.0);
        double incZ = 1.0 / (diffZ * 2.0 + 1.0);
        if (incX < 0.0 || incY < 0.0 || incZ < 0.0) {
            return 0.0f;
        }
        double offX = (1.0 - Math.floor(1.0 / incX) * incX) * 0.5 + boundingBox.minX;
        double offY = boundingBox.minY;
        double offZ = (1.0 - Math.floor(1.0 / incZ) * incZ) * 0.5 + boundingBox.minZ;
        CollisionUtil.LazyEntityCollisionContext context = new CollisionUtil.LazyEntityCollisionContext(target);
        int totalRays = 0;
        int missedRays = 0;
        for (double dx = 0.0; dx <= 1.0; dx += incX) {
            double fromX = Math.fma(dx, diffX, offX);
            for (double dy = 0.0; dy <= 1.0; dy += incY) {
                double fromY = Math.fma(dy, diffY, offY);
                for (double dz = 0.0; dz <= 1.0; dz += incZ) {
                    ++totalRays;
                    Vec3 from = new Vec3(fromX, fromY, Math.fma(dz, diffZ, offZ));
                    if (this.clipsAnything(from, source, context, blockCache, blockPos)) continue;
                    ++missedRays;
                }
            }
        }
        return (float)missedRays / (float)totalRays;
    }

    public static DamageSource getDefaultDamageSource(Level world, @Nullable Entity source) {
        return world.damageSources().explosion(source, Explosion.getIndirectSourceEntityInternal(source));
    }

    public Explosion(Level world, @Nullable Entity entity, double x, double y, double z, float power, List<BlockPos> affectedBlocks, BlockInteraction destructionType, ParticleOptions particle, ParticleOptions emitterParticle, Holder<SoundEvent> soundEvent) {
        this(world, entity, Explosion.getDefaultDamageSource(world, entity), null, x, y, z, power, false, destructionType, particle, emitterParticle, soundEvent);
        this.toBlow.addAll(affectedBlocks);
    }

    public Explosion(Level world, @Nullable Entity entity, double x, double y, double z, float power, boolean createFire, BlockInteraction destructionType, List<BlockPos> affectedBlocks) {
        this(world, entity, x, y, z, power, createFire, destructionType);
        this.toBlow.addAll(affectedBlocks);
    }

    public Explosion(Level world, @Nullable Entity entity, double x, double y, double z, float power, boolean createFire, BlockInteraction destructionType) {
        this(world, entity, Explosion.getDefaultDamageSource(world, entity), null, x, y, z, power, createFire, destructionType, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public Explosion(Level world, @Nullable Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x, double y, double z, float power, boolean createFire, BlockInteraction destructionType, ParticleOptions particle, ParticleOptions emitterParticle, Holder<SoundEvent> soundEvent) {
        this.level = world;
        this.source = entity;
        this.radius = (float)Math.max((double)power, 0.0);
        this.x = x;
        this.y = y;
        this.z = z;
        this.fire = createFire;
        this.blockInteraction = destructionType;
        this.damageSource = damageSource == null ? world.damageSources().explosion(this) : damageSource;
        this.damageCalculator = behavior == null ? this.makeDamageCalculator(entity) : behavior;
        this.smallExplosionParticles = particle;
        this.largeExplosionParticles = emitterParticle;
        this.explosionSound = soundEvent;
        this.yield = this.blockInteraction == BlockInteraction.DESTROY_WITH_DECAY ? 1.0f / this.radius : 1.0f;
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(entity);
    }

    public static float getSeenPercent(Vec3 source, Entity entity) {
        AABB axisalignedbb = entity.getBoundingBox();
        double d0 = 1.0 / ((axisalignedbb.maxX - axisalignedbb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.maxY - axisalignedbb.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.maxZ - axisalignedbb.minZ) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i = 0;
            int j = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = Mth.lerp(d5, axisalignedbb.minX, axisalignedbb.maxX);
                        double d9 = Mth.lerp(d6, axisalignedbb.minY, axisalignedbb.maxY);
                        double d10 = Mth.lerp(d7, axisalignedbb.minZ, axisalignedbb.maxZ);
                        Vec3 vec3d1 = new Vec3(d8 + d3, d9, d10 + d4);
                        if (entity.level().clip(new ClipContext(vec3d1, source, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public float radius() {
        return this.radius;
    }

    public Vec3 center() {
        return new Vec3(this.x, this.y, this.z);
    }

    public void explode() {
        if (this.radius < 0.1f) {
            return;
        }
        this.level.gameEvent(this.source, GameEvent.EXPLODE, new Vec3(this.x, this.y, this.z));
        this.blockCache = new Long2ObjectOpenHashMap();
        this.chunkPosCache = new long[16];
        Arrays.fill(this.chunkPosCache, ChunkPos.INVALID_CHUNK_POS);
        this.chunkCache = new LevelChunk[16];
        ExplosionBlockCache[] blockCache = new ExplosionBlockCache[512];
        int blockX = Mth.floor(this.x);
        int blockY = Mth.floor(this.y);
        int blockZ = Mth.floor(this.z);
        long key = BlockPos.asLong(blockX, blockY, blockZ);
        ExplosionBlockCache initialCache = this.getOrCacheExplosionBlock(blockX, blockY, blockZ, key, true);
        boolean flag = true;
        int ray = 0;
        int len = CACHED_RAYS.length;
        block0: while (ray < len) {
            ExplosionBlockCache cachedBlock = initialCache;
            double currX = this.x;
            double currY = this.y;
            double currZ = this.z;
            double incX = CACHED_RAYS[ray];
            double incY = CACHED_RAYS[ray + 1];
            double incZ = CACHED_RAYS[ray + 2];
            ray += 3;
            float power = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f);
            do {
                int cacheKey;
                int blockZ2;
                int blockY2;
                int blockX2;
                long key2;
                if (cachedBlock.key != (key2 = BlockPos.asLong(blockX2 = Mth.floor(currX), blockY2 = Mth.floor(currY), blockZ2 = Mth.floor(currZ))) && ((cachedBlock = blockCache[cacheKey = blockX2 & 7 | (blockY2 & 7) << 3 | (blockZ2 & 7) << 6]) == null || cachedBlock.key != key2)) {
                    blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(blockX2, blockY2, blockZ2, key2, true);
                }
                if (cachedBlock.outOfWorld) continue block0;
                BlockState iblockdata = cachedBlock.blockState;
                if ((power -= cachedBlock.resistance) > 0.0f && cachedBlock.shouldExplode == null && iblockdata.isDestroyable()) {
                    boolean shouldExplode = this.damageCalculator.shouldBlockExplode(this, this.level, cachedBlock.immutablePos, cachedBlock.blockState, power);
                    Boolean bl = cachedBlock.shouldExplode = shouldExplode ? Boolean.TRUE : Boolean.FALSE;
                    if (shouldExplode && (this.fire || !cachedBlock.blockState.isAir())) {
                        PistonMovingBlockEntity blockEntity;
                        BlockEntity extension;
                        this.toBlow.add((Object)cachedBlock.immutablePos);
                        if (!GlobalConfiguration.get().unsupportedSettings.allowHeadlessPistons && iblockdata.getBlock() == Blocks.MOVING_PISTON && (extension = this.level.getBlockEntity(cachedBlock.immutablePos)) instanceof PistonMovingBlockEntity && (blockEntity = (PistonMovingBlockEntity)extension).isSourcePiston()) {
                            Direction direction = iblockdata.getValue(DirectionalBlock.FACING);
                            this.toBlow.add((Object)cachedBlock.immutablePos.relative(direction.getOpposite()));
                        }
                    }
                }
                currX += incX;
                currY += incY;
                currZ += incZ;
            } while ((power -= 0.22500001f) > 0.0f);
        }
        float f2 = this.radius * 2.0f;
        int i = Mth.floor(this.x - (double)f2 - 1.0);
        int j = Mth.floor(this.x + (double)f2 + 1.0);
        int l = Mth.floor(this.y - (double)f2 - 1.0);
        int i1 = Mth.floor(this.y + (double)f2 + 1.0);
        int j1 = Mth.floor(this.z - (double)f2 - 1.0);
        int k1 = Mth.floor(this.z + (double)f2 + 1.0);
        List<Entity> list = this.level.getEntities(this.source, new AABB(i, l, j1, j, i1, k1), (Predicate<? super Entity>)((com.google.common.base.Predicate)entity -> entity.isAlive() && !entity.isSpectator()));
        Vec3 vec3d = new Vec3(this.x, this.y, this.z);
        Iterator<Entity> iterator = list.iterator();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        while (iterator.hasNext()) {
            Player entityhuman;
            double d13;
            double seenFraction;
            double d10;
            double d9;
            double d8;
            double d11;
            double d7;
            Entity entity2 = iterator.next();
            if (entity2.ignoreExplosion(this) || !((d7 = Math.sqrt(entity2.distanceToSqr(vec3d)) / (double)f2) <= 1.0) || (d11 = Math.sqrt((d8 = entity2.getX() - this.x) * d8 + (d9 = (entity2 instanceof PrimedTnt ? entity2.getY() : entity2.getEyeY()) - this.y) * d9 + (d10 = entity2.getZ() - this.z) * d10)) == 0.0) continue;
            d8 /= d11;
            d9 /= d11;
            d10 /= d11;
            if (this.damageCalculator.shouldDamageEntity(this, entity2)) {
                if (entity2 instanceof EnderDragonPart) continue;
                entity2.lastDamageCancelled = false;
                seenFraction = this.getBlockDensity(vec3d, entity2, blockCache, blockPos);
                if (entity2 instanceof EnderDragon) {
                    for (EnderDragonPart entityComplexPart : ((EnderDragon)entity2).subEntities) {
                        if (!list.contains(entityComplexPart)) continue;
                        entityComplexPart.hurt(this.damageSource, this.damageCalculator.getEntityDamageAmount(this, entity2));
                    }
                } else {
                    double factor = (1.0 - d7) * seenFraction;
                    entity2.hurt(this.damageSource, (float)((factor * factor + factor) / 2.0 * 7.0 * (double)f2 + 1.0));
                }
                if (entity2.lastDamageCancelled) {
                    continue;
                }
            } else {
                seenFraction = this.getBlockDensity(vec3d, entity2, blockCache, blockPos);
            }
            double d12 = (1.0 - d7) * seenFraction * (double)this.damageCalculator.getKnockbackMultiplier(entity2);
            if (entity2 instanceof LivingEntity) {
                LivingEntity entityliving = (LivingEntity)entity2;
                d13 = entity2 instanceof Player && this.level.paperConfig().environment.disableExplosionKnockback ? 0.0 : d12 * (1.0 - entityliving.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE));
            } else {
                d13 = d12;
            }
            Vec3 vec3d1 = new Vec3(d8 *= d13, d9 *= d13, d10 *= d13);
            if (entity2 instanceof LivingEntity) {
                EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)entity2.getBukkitEntity(), this.damageSource.getEntity() != null ? this.damageSource.getEntity() : this.source, EntityKnockbackEvent.Cause.EXPLOSION, d13, vec3d1);
                vec3d1 = event.isCancelled() ? Vec3.ZERO : CraftVector.toNMS(event.getKnockback());
            }
            entity2.setDeltaMovement(entity2.getDeltaMovement().add(vec3d1));
            if (!(!(entity2 instanceof Player) || (entityhuman = (Player)entity2).isSpectator() || entityhuman.isCreative() && entityhuman.getAbilities().flying || this.level.paperConfig().environment.disableExplosionKnockback)) {
                this.hitPlayers.put(entityhuman, vec3d1);
            }
            entity2.onExplosionHit(this.source);
        }
        this.blockCache = null;
        this.chunkPosCache = null;
        this.chunkCache = null;
    }

    public void finalizeExplosion(boolean particles) {
        if (this.level.isClientSide) {
            this.level.playLocalSound(this.x, this.y, this.z, this.explosionSound.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean flag1 = this.interactsWithBlocks();
        if (particles) {
            ParticleOptions particleparam = this.radius >= 2.0f && flag1 ? this.largeExplosionParticles : this.smallExplosionParticles;
            this.level.addParticle(particleparam, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }
        if (flag1) {
            List bukkitBlocks;
            this.level.getProfiler().push("explosion_blocks");
            ArrayList list = new ArrayList();
            Util.shuffle(this.toBlow, this.level.random);
            ObjectListIterator objectlistiterator = this.toBlow.iterator();
            CraftWorld bworld = this.level.getWorld();
            Location location = new Location((World)bworld, this.x, this.y, this.z);
            ObjectArrayList blockList = new ObjectArrayList();
            for (int i1 = this.toBlow.size() - 1; i1 >= 0; --i1) {
                BlockPos cpos = (BlockPos)this.toBlow.get(i1);
                org.bukkit.block.Block bblock = bworld.getBlockAt(cpos.getX(), cpos.getY(), cpos.getZ());
                if (bblock.getType().isAir()) continue;
                blockList.add(bblock);
            }
            if (this.source != null) {
                EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this.source, (List<org.bukkit.block.Block>)blockList, this.yield, this.getBlockInteraction());
                this.wasCanceled = event.isCancelled();
                bukkitBlocks = event.blockList();
                this.yield = event.getYield();
            } else {
                org.bukkit.block.Block block = location.getBlock();
                org.bukkit.block.BlockState blockState = this.damageSource.getDirectBlockState() != null ? this.damageSource.getDirectBlockState() : block.getState();
                BlockExplodeEvent event = CraftEventFactory.callBlockExplodeEvent(block, blockState, (List<org.bukkit.block.Block>)blockList, this.yield, this.getBlockInteraction());
                this.wasCanceled = event.isCancelled();
                bukkitBlocks = event.blockList();
                this.yield = event.getYield();
            }
            this.toBlow.clear();
            for (org.bukkit.block.Block bblock : bukkitBlocks) {
                BlockPos coords = new BlockPos(bblock.getX(), bblock.getY(), bblock.getZ());
                this.toBlow.add((Object)coords);
            }
            if (this.wasCanceled) {
                return;
            }
            for (BlockPos blockposition : this.toBlow) {
                BlockState iblockdata = this.level.getBlockState(blockposition);
                Block block = iblockdata.getBlock();
                if (block instanceof TntBlock) {
                    BlockPos sourceBlock;
                    Entity sourceEntity = this.source == null ? null : this.source;
                    BlockPos blockPos = sourceBlock = sourceEntity == null ? BlockPos.containing(this.x, this.y, this.z) : null;
                    if (!CraftEventFactory.callTNTPrimeEvent(this.level, blockposition, TNTPrimeEvent.PrimeCause.EXPLOSION, sourceEntity, sourceBlock)) {
                        this.level.sendBlockUpdated(blockposition, Blocks.AIR.defaultBlockState(), iblockdata, 3);
                        continue;
                    }
                }
                this.level.getBlockState(blockposition).onExplosionHit(this.level, blockposition, this, (itemstack, blockposition1) -> Explosion.addOrAppendStack(list, itemstack, blockposition1));
            }
            for (Pair pair : list) {
                Block.popResource(this.level, (BlockPos)pair.getSecond(), (ItemStack)pair.getFirst());
            }
            this.level.getProfiler().pop();
        }
        if (this.fire) {
            for (BlockPos blockposition12 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.getBlockState(blockposition12).isAir() || !this.level.getBlockState(blockposition12.below()).isSolidRender(this.level, blockposition12.below()) || CraftEventFactory.callBlockIgniteEvent(this.level, blockposition12, this).isCancelled()) continue;
                this.level.setBlockAndUpdate(blockposition12, BaseFireBlock.getState(this.level, blockposition12));
            }
        }
    }

    private static void addOrAppendStack(List<Pair<ItemStack, BlockPos>> stacks, ItemStack stack, BlockPos pos) {
        if (stack.isEmpty()) {
            return;
        }
        for (int i = 0; i < stacks.size(); ++i) {
            Pair<ItemStack, BlockPos> pair = stacks.get(i);
            ItemStack itemstack1 = (ItemStack)pair.getFirst();
            if (!ItemEntity.areMergable(itemstack1, stack)) continue;
            stacks.set(i, (Pair<ItemStack, BlockPos>)Pair.of((Object)ItemEntity.merge(itemstack1, stack, 16), (Object)((BlockPos)pair.getSecond())));
            if (!stack.isEmpty()) continue;
            return;
        }
        stacks.add((Pair<ItemStack, BlockPos>)Pair.of((Object)stack, (Object)pos));
    }

    public boolean interactsWithBlocks() {
        return this.blockInteraction != BlockInteraction.KEEP;
    }

    public Map<Player, Vec3> getHitPlayers() {
        return this.hitPlayers;
    }

    @Nullable
    private static LivingEntity getIndirectSourceEntityInternal(@Nullable Entity from) {
        Projectile iprojectile;
        Entity entity1;
        if (from == null) {
            return null;
        }
        if (from instanceof PrimedTnt) {
            PrimedTnt entitytntprimed = (PrimedTnt)from;
            return entitytntprimed.getOwner();
        }
        if (from instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)from;
            return entityliving;
        }
        if (from instanceof Projectile && (entity1 = (iprojectile = (Projectile)from).getOwner()) instanceof LivingEntity) {
            LivingEntity entityliving1 = (LivingEntity)entity1;
            return entityliving1;
        }
        return null;
    }

    @Nullable
    public LivingEntity getIndirectSourceEntity() {
        return Explosion.getIndirectSourceEntityInternal(this.source);
    }

    @Nullable
    public Entity getDirectSourceEntity() {
        return this.source;
    }

    public void clearToBlow() {
        this.toBlow.clear();
    }

    public List<BlockPos> getToBlow() {
        return this.toBlow;
    }

    public BlockInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    public ParticleOptions getSmallExplosionParticles() {
        return this.smallExplosionParticles;
    }

    public ParticleOptions getLargeExplosionParticles() {
        return this.largeExplosionParticles;
    }

    public Holder<SoundEvent> getExplosionSound() {
        return this.explosionSound;
    }

    public boolean canTriggerBlocks() {
        return this.blockInteraction == BlockInteraction.TRIGGER_BLOCK && !this.level.isClientSide() ? (this.source != null && this.source.getType() == EntityType.BREEZE_WIND_CHARGE ? this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) : true) : false;
    }

    private float getBlockDensity(Vec3 vec3d, Entity entity, ExplosionBlockCache[] blockCache, BlockPos.MutableBlockPos blockPos) {
        if (!this.level.paperConfig().environment.optimizeExplosions) {
            return this.getSeenFraction(vec3d, entity, blockCache, blockPos);
        }
        CacheKey key = new CacheKey(this, entity.getBoundingBox());
        Float blockDensity = this.level.explosionDensityCache.get(key);
        if (blockDensity == null) {
            blockDensity = Float.valueOf(this.getSeenFraction(vec3d, entity, blockCache, blockPos));
            this.level.explosionDensityCache.put(key, blockDensity);
        }
        return blockDensity.floatValue();
    }

    static {
        DoubleArrayList rayCoords = new DoubleArrayList();
        for (int x = 0; x <= 15; ++x) {
            for (int y = 0; y <= 15; ++y) {
                for (int z = 0; z <= 15; ++z) {
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    double xDir = (float)x / 15.0f * 2.0f - 1.0f;
                    double yDir = (float)y / 15.0f * 2.0f - 1.0f;
                    double zDir = (float)z / 15.0f * 2.0f - 1.0f;
                    double mag = Math.sqrt(xDir * xDir + yDir * yDir + zDir * zDir);
                    rayCoords.add(xDir / mag * (double)0.3f);
                    rayCoords.add(yDir / mag * (double)0.3f);
                    rayCoords.add(zDir / mag * (double)0.3f);
                }
            }
        }
        CACHED_RAYS = rayCoords.toDoubleArray();
        ZERO_RESISTANCE = Float.valueOf(-0.3f);
    }

    public static enum BlockInteraction {
        KEEP,
        DESTROY,
        DESTROY_WITH_DECAY,
        TRIGGER_BLOCK;

    }

    static class CacheKey {
        private final Level world;
        private final double posX;
        private final double posY;
        private final double posZ;
        private final double minX;
        private final double minY;
        private final double minZ;
        private final double maxX;
        private final double maxY;
        private final double maxZ;

        public CacheKey(Explosion explosion, AABB aabb) {
            this.world = explosion.level;
            this.posX = explosion.x;
            this.posY = explosion.y;
            this.posZ = explosion.z;
            this.minX = aabb.minX;
            this.minY = aabb.minY;
            this.minZ = aabb.minZ;
            this.maxX = aabb.maxX;
            this.maxY = aabb.maxY;
            this.maxZ = aabb.maxZ;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (Double.compare(cacheKey.posX, this.posX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posY, this.posY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.posZ, this.posZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minX, this.minX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minY, this.minY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.minZ, this.minZ) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxX, this.maxX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxY, this.maxY) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.maxZ, this.maxZ) != 0) {
                return false;
            }
            return this.world.equals(cacheKey.world);
        }

        public int hashCode() {
            int result = this.world.hashCode();
            long temp = Double.doubleToLongBits(this.posX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.posZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxX);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxY);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.maxZ);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

