/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.Graph;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;

public class FeatureSorter {
    public static <T> List<StepFeatureData> buildFeaturesPerStep(List<T> biomes, Function<T, List<HolderSet<PlacedFeature>>> biomesToPlacedFeaturesList, boolean listInvolvedBiomesOnFailure) {
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        MutableInt mutableInt = new MutableInt(0);
        record FeatureData(int featureIndex, int step, PlacedFeature feature) {
        }
        Comparator<FeatureData> comparator = Comparator.comparingInt(FeatureData::step).thenComparingInt(FeatureData::featureIndex);
        TreeMap<FeatureData, Set> map = new TreeMap<FeatureData, Set>(comparator);
        int i = 0;
        for (T object : biomes) {
            ArrayList list = Lists.newArrayList();
            List<HolderSet<PlacedFeature>> list2 = biomesToPlacedFeaturesList.apply(object);
            i = Math.max(i, list2.size());
            for (int j = 0; j < list2.size(); ++j) {
                for (Holder holder : (HolderSet)list2.get(j)) {
                    PlacedFeature placedFeature = (PlacedFeature)holder.value();
                    list.add(new FeatureData(object2IntMap.computeIfAbsent((Object)placedFeature, feature -> mutableInt.getAndIncrement()), j, placedFeature));
                }
            }
            for (int k = 0; k < list.size(); ++k) {
                Set set = map.computeIfAbsent((FeatureData)list.get(k), feature -> new TreeSet(comparator));
                if (k >= list.size() - 1) continue;
                set.add((FeatureData)list.get(k + 1));
            }
        }
        TreeSet<FeatureData> set2 = new TreeSet<FeatureData>(comparator);
        TreeSet<FeatureData> set3 = new TreeSet<FeatureData>(comparator);
        ArrayList list3 = Lists.newArrayList();
        for (FeatureData lv : map.keySet()) {
            if (!set3.isEmpty()) {
                throw new IllegalStateException("You somehow broke the universe; DFS bork (iteration finished with non-empty in-progress vertex set");
            }
            if (set2.contains(lv) || !Graph.depthFirstSearch(map, set2, set3, list3::add, lv)) continue;
            if (listInvolvedBiomesOnFailure) {
                int l;
                ArrayList<T> list4 = new ArrayList<T>(biomes);
                do {
                    l = list4.size();
                    ListIterator listIterator = list4.listIterator();
                    while (listIterator.hasNext()) {
                        Object object2 = listIterator.next();
                        listIterator.remove();
                        try {
                            FeatureSorter.buildFeaturesPerStep(list4, biomesToPlacedFeaturesList, false);
                        }
                        catch (IllegalStateException illegalStateException) {
                            continue;
                        }
                        listIterator.add(object2);
                    }
                } while (l != list4.size());
                throw new IllegalStateException("Feature order cycle found, involved sources: " + String.valueOf(list4));
            }
            throw new IllegalStateException("Feature order cycle found");
        }
        Collections.reverse(list3);
        ImmutableList.Builder builder = ImmutableList.builder();
        int m = 0;
        while (m < i) {
            int n = m++;
            List<PlacedFeature> list5 = list3.stream().filter(feature -> feature.step() == n).map(FeatureData::feature).collect(Collectors.toList());
            builder.add((Object)new StepFeatureData(list5));
        }
        return builder.build();
    }

    public record StepFeatureData(List<PlacedFeature> features, ToIntFunction<PlacedFeature> indexMapping) {
        StepFeatureData(List<PlacedFeature> features) {
            this(features, Util.createIndexIdentityLookup(features));
        }
    }
}

