/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class BambooStalkBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<BambooStalkBlock> CODEC = BambooStalkBlock.simpleCodec(BambooStalkBlock::new);
    protected static final float SMALL_LEAVES_AABB_OFFSET = 3.0f;
    protected static final float LARGE_LEAVES_AABB_OFFSET = 5.0f;
    protected static final float COLLISION_AABB_OFFSET = 1.5f;
    protected static final VoxelShape SMALL_SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    protected static final VoxelShape LARGE_SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    protected static final VoxelShape COLLISION_SHAPE = Block.box(6.5, 0.0, 6.5, 9.5, 16.0, 9.5);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;
    public static final EnumProperty<BambooLeaves> LEAVES = BlockStateProperties.BAMBOO_LEAVES;
    public static final IntegerProperty STAGE = BlockStateProperties.STAGE;
    public static final int MAX_HEIGHT = 16;
    public static final int STAGE_GROWING = 0;
    public static final int STAGE_DONE_GROWING = 1;
    public static final int AGE_THIN_BAMBOO = 0;
    public static final int AGE_THICK_BAMBOO = 1;

    public MapCodec<BambooStalkBlock> codec() {
        return CODEC;
    }

    public BambooStalkBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(AGE, 0)).setValue(LEAVES, BambooLeaves.NONE)).setValue(STAGE, 0));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(AGE, LEAVES, STAGE);
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape voxelshape = state.getValue(LEAVES) == BambooLeaves.LARGE ? LARGE_SHAPE : SMALL_SHAPE;
        Vec3 vec3d = state.getOffset(world, pos);
        return voxelshape.move(vec3d.x, vec3d.y, vec3d.z);
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.getOffset(world, pos);
        return COLLISION_SHAPE.move(vec3d.x, vec3d.y, vec3d.z);
    }

    @Override
    protected boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluid = ctx.getLevel().getFluidState(ctx.getClickedPos());
        if (!fluid.isEmpty()) {
            return null;
        }
        BlockState iblockdata = ctx.getLevel().getBlockState(ctx.getClickedPos().below());
        if (iblockdata.is(BlockTags.BAMBOO_PLANTABLE_ON)) {
            if (iblockdata.is(Blocks.BAMBOO_SAPLING)) {
                return (BlockState)this.defaultBlockState().setValue(AGE, 0);
            }
            if (iblockdata.is(Blocks.BAMBOO)) {
                int i = iblockdata.getValue(AGE) > 0 ? 1 : 0;
                return (BlockState)this.defaultBlockState().setValue(AGE, i);
            }
            BlockState iblockdata1 = ctx.getLevel().getBlockState(ctx.getClickedPos().above());
            return iblockdata1.is(Blocks.BAMBOO) ? (BlockState)this.defaultBlockState().setValue(AGE, iblockdata1.getValue(AGE)) : Blocks.BAMBOO_SAPLING.defaultBlockState();
        }
        return null;
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive(world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    @Override
    protected boolean isRandomlyTicking(BlockState state) {
        return state.getValue(STAGE) == 0;
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i;
        if (state.getValue(STAGE) == 0 && random.nextFloat() < (float)world.spigotConfig.bambooModifier / 300.0f && world.isEmptyBlock(pos.above()) && world.getRawBrightness(pos.above(), 0) >= 9 && (i = this.getHeightBelowUpToMax(world, pos) + 1) < world.paperConfig().maxGrowthHeight.bamboo.max) {
            this.growBamboo(state, world, pos, random, i);
        }
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).is(BlockTags.BAMBOO_PLANTABLE_ON);
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive(world, pos)) {
            world.scheduleTick(pos, this, 1);
        }
        if (direction == Direction.UP && neighborState.is(Blocks.BAMBOO) && neighborState.getValue(AGE) > state.getValue(AGE)) {
            world.setBlock(pos, (BlockState)state.cycle(AGE), 2);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        int j;
        int i = this.getHeightAboveUpToMax(world, pos);
        return i + (j = this.getHeightBelowUpToMax(world, pos)) + 1 < ((Level)world).paperConfig().maxGrowthHeight.bamboo.max && world.getBlockState(pos.above(i)).getValue(STAGE) != 1;
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int i = this.getHeightAboveUpToMax(world, pos);
        int j = this.getHeightBelowUpToMax(world, pos);
        int k = i + j + 1;
        int l = 1 + random.nextInt(2);
        for (int i1 = 0; i1 < l; ++i1) {
            BlockPos blockposition1 = pos.above(i);
            BlockState iblockdata1 = world.getBlockState(blockposition1);
            if (k >= world.paperConfig().maxGrowthHeight.bamboo.max || !iblockdata1.is(Blocks.BAMBOO) || iblockdata1.getValue(STAGE) == 1 || !world.isEmptyBlock(blockposition1.above())) {
                return;
            }
            this.growBamboo(iblockdata1, world, blockposition1, random, k);
            ++i;
            ++k;
        }
    }

    @Override
    protected float getDestroyProgress(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        return player.getMainHandItem().getItem() instanceof SwordItem ? 1.0f : super.getDestroyProgress(state, player, world, pos);
    }

    protected void growBamboo(BlockState state, Level world, BlockPos pos, RandomSource random, int height) {
        int k;
        BlockState iblockdata1 = world.getBlockState(pos.below());
        BlockPos blockposition1 = pos.below(2);
        BlockState iblockdata2 = world.getBlockState(blockposition1);
        BambooLeaves blockpropertybamboosize = BambooLeaves.NONE;
        boolean shouldUpdateOthers = false;
        if (height >= 1) {
            if (iblockdata1.is(Blocks.BAMBOO) && iblockdata1.getValue(LEAVES) != BambooLeaves.NONE) {
                if (iblockdata1.is(Blocks.BAMBOO) && iblockdata1.getValue(LEAVES) != BambooLeaves.NONE) {
                    blockpropertybamboosize = BambooLeaves.LARGE;
                    if (iblockdata2.is(Blocks.BAMBOO)) {
                        shouldUpdateOthers = true;
                    }
                }
            } else {
                blockpropertybamboosize = BambooLeaves.SMALL;
            }
        }
        int j = state.getValue(AGE) != 1 && !iblockdata2.is(Blocks.BAMBOO) ? 0 : 1;
        int n = k = (height < world.paperConfig().maxGrowthHeight.bamboo.min || random.nextFloat() >= 0.25f) && height != world.paperConfig().maxGrowthHeight.bamboo.max - 1 ? 0 : 1;
        if (CraftEventFactory.handleBlockSpreadEvent(world, pos, pos.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AGE, j)).setValue(LEAVES, blockpropertybamboosize)).setValue(STAGE, k), 3) && shouldUpdateOthers) {
            world.setBlock(pos.below(), (BlockState)iblockdata1.setValue(LEAVES, BambooLeaves.SMALL), 3);
            world.setBlock(blockposition1, (BlockState)iblockdata2.setValue(LEAVES, BambooLeaves.NONE), 3);
        }
    }

    protected int getHeightAboveUpToMax(BlockGetter world, BlockPos pos) {
        int i;
        for (i = 0; i < ((Level)world).paperConfig().maxGrowthHeight.bamboo.max && world.getBlockState(pos.above(i + 1)).is(Blocks.BAMBOO); ++i) {
        }
        return i;
    }

    protected int getHeightBelowUpToMax(BlockGetter world, BlockPos pos) {
        int i;
        for (i = 0; i < ((Level)world).paperConfig().maxGrowthHeight.bamboo.max && world.getBlockState(pos.below(i + 1)).is(Blocks.BAMBOO); ++i) {
        }
        return i;
    }
}

