/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BigDripleafBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<BigDripleafBlock> CODEC = BigDripleafBlock.simpleCodec(BigDripleafBlock::new);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final EnumProperty<Tilt> TILT = BlockStateProperties.TILT;
    private static final int NO_TICK = -1;
    private static final Object2IntMap<Tilt> DELAY_UNTIL_NEXT_TILT_STATE = (Object2IntMap)Util.make(new Object2IntArrayMap(), object2intarraymap -> {
        object2intarraymap.defaultReturnValue(-1);
        object2intarraymap.put((Object)Tilt.UNSTABLE, 10);
        object2intarraymap.put((Object)Tilt.PARTIAL, 10);
        object2intarraymap.put((Object)Tilt.FULL, 100);
    });
    private static final int MAX_GEN_HEIGHT = 5;
    private static final int STEM_WIDTH = 6;
    private static final int ENTITY_DETECTION_MIN_Y = 11;
    private static final int LOWEST_LEAF_TOP = 13;
    private static final Map<Tilt, VoxelShape> LEAF_SHAPES = ImmutableMap.of((Object)Tilt.NONE, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.UNSTABLE, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.PARTIAL, (Object)Block.box(0.0, 11.0, 0.0, 16.0, 13.0, 16.0), (Object)Tilt.FULL, (Object)Shapes.empty());
    private static final VoxelShape STEM_SLICER = Block.box(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private static final Map<Direction, VoxelShape> STEM_SHAPES = ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.joinUnoptimized(BigDripleafStemBlock.NORTH_SHAPE, STEM_SLICER, BooleanOp.ONLY_FIRST), (Object)Direction.SOUTH, (Object)Shapes.joinUnoptimized(BigDripleafStemBlock.SOUTH_SHAPE, STEM_SLICER, BooleanOp.ONLY_FIRST), (Object)Direction.EAST, (Object)Shapes.joinUnoptimized(BigDripleafStemBlock.EAST_SHAPE, STEM_SLICER, BooleanOp.ONLY_FIRST), (Object)Direction.WEST, (Object)Shapes.joinUnoptimized(BigDripleafStemBlock.WEST_SHAPE, STEM_SLICER, BooleanOp.ONLY_FIRST));
    private final Map<BlockState, VoxelShape> shapesCache;

    public MapCodec<BigDripleafBlock> codec() {
        return CODEC;
    }

    protected BigDripleafBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(WATERLOGGED, false)).setValue(HorizontalDirectionalBlock.FACING, Direction.NORTH)).setValue(TILT, Tilt.NONE));
        this.shapesCache = this.getShapeForEachState(BigDripleafBlock::calculateShape);
    }

    private static VoxelShape calculateShape(BlockState state) {
        return Shapes.or(LEAF_SHAPES.get(state.getValue(TILT)), STEM_SHAPES.get(state.getValue(HorizontalDirectionalBlock.FACING)));
    }

    public static void placeWithRandomHeight(LevelAccessor world, RandomSource random, BlockPos pos, Direction direction) {
        int j;
        int i = Mth.nextInt(random, 2, 5);
        BlockPos.MutableBlockPos blockposition_mutableblockposition = pos.mutable();
        for (j = 0; j < i && BigDripleafBlock.canPlaceAt(world, blockposition_mutableblockposition, world.getBlockState(blockposition_mutableblockposition)); ++j) {
            blockposition_mutableblockposition.move(Direction.UP);
        }
        int k = pos.getY() + j - 1;
        blockposition_mutableblockposition.setY(pos.getY());
        while (blockposition_mutableblockposition.getY() < k) {
            BigDripleafStemBlock.place(world, blockposition_mutableblockposition, world.getFluidState(blockposition_mutableblockposition), direction);
            blockposition_mutableblockposition.move(Direction.UP);
        }
        BigDripleafBlock.place(world, blockposition_mutableblockposition, world.getFluidState(blockposition_mutableblockposition), direction);
    }

    private static boolean canReplace(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER) || state.is(Blocks.SMALL_DRIPLEAF);
    }

    protected static boolean canPlaceAt(LevelHeightAccessor world, BlockPos pos, BlockState state) {
        return !world.isOutsideBuildHeight(pos) && BigDripleafBlock.canReplace(state);
    }

    protected static boolean place(LevelAccessor world, BlockPos pos, FluidState fluidState, Direction direction) {
        BlockState iblockdata = (BlockState)((BlockState)Blocks.BIG_DRIPLEAF.defaultBlockState().setValue(WATERLOGGED, fluidState.isSourceOfType(Fluids.WATER))).setValue(HorizontalDirectionalBlock.FACING, direction);
        return world.setBlock(pos, iblockdata, 3);
    }

    @Override
    protected void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        this.setTiltAndScheduleTick(state, world, hit.getBlockPos(), Tilt.FULL, SoundEvents.BIG_DRIPLEAF_TILT_DOWN, projectile);
    }

    @Override
    protected FluidState getFluidState(BlockState state) {
        return state.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockposition1 = pos.below();
        BlockState iblockdata1 = world.getBlockState(blockposition1);
        return iblockdata1.is(this) || iblockdata1.is(Blocks.BIG_DRIPLEAF_STEM) || iblockdata1.is(BlockTags.BIG_DRIPLEAF_PLACEABLE);
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !state.canSurvive(world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (state.getValue(WATERLOGGED).booleanValue()) {
            world.scheduleTick(pos, Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return direction == Direction.UP && neighborState.is(this) ? Blocks.BIG_DRIPLEAF_STEM.withPropertiesOf(state) : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        BlockState iblockdata1 = world.getBlockState(pos.above());
        return BigDripleafBlock.canReplace(iblockdata1);
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockState iblockdata1;
        BlockPos blockposition1 = pos.above();
        if (BigDripleafBlock.canPlaceAt(world, blockposition1, iblockdata1 = world.getBlockState(blockposition1))) {
            Direction enumdirection = state.getValue(HorizontalDirectionalBlock.FACING);
            BigDripleafStemBlock.place(world, pos, state.getFluidState(), enumdirection);
            BigDripleafBlock.place(world, blockposition1, iblockdata1.getFluidState(), enumdirection);
        }
    }

    @Override
    protected void entityInside(BlockState state, Level world, BlockPos pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (!world.isClientSide && state.getValue(TILT) == Tilt.NONE && BigDripleafBlock.canEntityTilt(pos, entity) && !world.hasNeighborSignal(pos)) {
            PlayerInteractEvent cancellable;
            if (entity instanceof Player) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((Player)entity, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            this.setTiltAndScheduleTick(state, world, pos, Tilt.UNSTABLE, null, entity);
        }
    }

    @Override
    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.hasNeighborSignal(pos)) {
            BigDripleafBlock.resetTilt(state, world, pos);
        } else {
            Tilt tilt = state.getValue(TILT);
            if (tilt == Tilt.UNSTABLE) {
                this.setTiltAndScheduleTick(state, world, pos, Tilt.PARTIAL, SoundEvents.BIG_DRIPLEAF_TILT_DOWN, null);
            } else if (tilt == Tilt.PARTIAL) {
                this.setTiltAndScheduleTick(state, world, pos, Tilt.FULL, SoundEvents.BIG_DRIPLEAF_TILT_DOWN, null);
            } else if (tilt == Tilt.FULL) {
                BigDripleafBlock.resetTilt(state, world, pos);
            }
        }
    }

    @Override
    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.hasNeighborSignal(pos)) {
            BigDripleafBlock.resetTilt(state, world, pos);
        }
    }

    private static void playTiltSound(Level world, BlockPos pos, SoundEvent soundEvent) {
        float f = Mth.randomBetween(world.random, 0.8f, 1.2f);
        world.playSound((Player)null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, f);
    }

    private static boolean canEntityTilt(BlockPos pos, net.minecraft.world.entity.Entity entity) {
        return entity.onGround() && entity.position().y > (double)((float)pos.getY() + 0.6875f);
    }

    private void setTiltAndScheduleTick(BlockState iblockdata, Level world, BlockPos blockposition, Tilt tilt, @Nullable SoundEvent soundeffect, @Nullable net.minecraft.world.entity.Entity entity) {
        int i;
        if (!BigDripleafBlock.setTilt(iblockdata, world, blockposition, tilt, entity)) {
            return;
        }
        if (soundeffect != null) {
            BigDripleafBlock.playTiltSound(world, blockposition, soundeffect);
        }
        if ((i = DELAY_UNTIL_NEXT_TILT_STATE.getInt((Object)tilt)) != -1) {
            world.scheduleTick(blockposition, this, i);
        }
    }

    private static void resetTilt(BlockState state, Level world, BlockPos pos) {
        BigDripleafBlock.setTilt(state, world, pos, Tilt.NONE, null);
        if (state.getValue(TILT) != Tilt.NONE) {
            BigDripleafBlock.playTiltSound(world, pos, SoundEvents.BIG_DRIPLEAF_TILT_UP);
        }
    }

    private static boolean setTilt(BlockState iblockdata, Level world, BlockPos blockposition, Tilt tilt, @Nullable net.minecraft.world.entity.Entity entity) {
        if (entity != null && !CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (BlockState)iblockdata.setValue(TILT, tilt))) {
            return false;
        }
        Tilt tilt1 = iblockdata.getValue(TILT);
        world.setBlock(blockposition, (BlockState)iblockdata.setValue(TILT, tilt), 2);
        if (tilt.causesVibration() && tilt != tilt1) {
            world.gameEvent((net.minecraft.world.entity.Entity)null, GameEvent.BLOCK_CHANGE, blockposition);
        }
        return true;
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return LEAF_SHAPES.get(state.getValue(TILT));
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shapesCache.get(state);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState iblockdata = ctx.getLevel().getBlockState(ctx.getClickedPos().below());
        FluidState fluid = ctx.getLevel().getFluidState(ctx.getClickedPos());
        boolean flag = iblockdata.is(Blocks.BIG_DRIPLEAF) || iblockdata.is(Blocks.BIG_DRIPLEAF_STEM);
        return (BlockState)((BlockState)this.defaultBlockState().setValue(WATERLOGGED, fluid.isSourceOfType(Fluids.WATER))).setValue(HorizontalDirectionalBlock.FACING, flag ? iblockdata.getValue(HorizontalDirectionalBlock.FACING) : ctx.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(WATERLOGGED, HorizontalDirectionalBlock.FACING, TILT);
    }
}

