/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.SculkBloomEvent;
import org.slf4j.Logger;

public class SculkSpreader {
    public static final int MAX_GROWTH_RATE_RADIUS = 24;
    public static final int MAX_CHARGE = 1000;
    public static final float MAX_DECAY_FACTOR = 0.5f;
    private static final int MAX_CURSORS = 32;
    public static final int SHRIEKER_PLACEMENT_RATE = 11;
    final boolean isWorldGeneration;
    private final TagKey<Block> replaceableBlocks;
    private final int growthSpawnCost;
    private final int noGrowthRadius;
    private final int chargeDecayRate;
    private final int additionalDecayRate;
    private List<ChargeCursor> cursors = new ArrayList<ChargeCursor>();
    private static final Logger LOGGER = LogUtils.getLogger();
    public Level level;

    public SculkSpreader(boolean worldGen, TagKey<Block> replaceableTag, int extraBlockChance, int maxDistance, int spreadChance, int decayChance) {
        this.isWorldGeneration = worldGen;
        this.replaceableBlocks = replaceableTag;
        this.growthSpawnCost = extraBlockChance;
        this.noGrowthRadius = maxDistance;
        this.chargeDecayRate = spreadChance;
        this.additionalDecayRate = decayChance;
    }

    public static SculkSpreader createLevelSpreader() {
        return new SculkSpreader(false, BlockTags.SCULK_REPLACEABLE, 10, 4, 10, 5);
    }

    public static SculkSpreader createWorldGenSpreader() {
        return new SculkSpreader(true, BlockTags.SCULK_REPLACEABLE_WORLD_GEN, 50, 1, 5, 10);
    }

    public TagKey<Block> replaceableBlocks() {
        return this.replaceableBlocks;
    }

    public int growthSpawnCost() {
        return this.growthSpawnCost;
    }

    public int noGrowthRadius() {
        return this.noGrowthRadius;
    }

    public int chargeDecayRate() {
        return this.chargeDecayRate;
    }

    public int additionalDecayRate() {
        return this.additionalDecayRate;
    }

    public boolean isWorldGeneration() {
        return this.isWorldGeneration;
    }

    @VisibleForTesting
    public List<ChargeCursor> getCursors() {
        return this.cursors;
    }

    public void clear() {
        this.cursors.clear();
    }

    public void load(CompoundTag nbt) {
        if (nbt.contains("cursors", 9)) {
            this.cursors.clear();
            DataResult dataresult = ChargeCursor.CODEC.listOf().parse(new Dynamic<ListTag>(NbtOps.INSTANCE, nbt.getList("cursors", 10)));
            Logger logger = LOGGER;
            Objects.requireNonNull(logger);
            List list = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElseGet(ArrayList::new);
            int i = Math.min(list.size(), 32);
            for (int j = 0; j < i; ++j) {
                this.addCursor((ChargeCursor)list.get(j));
            }
        }
    }

    public void save(CompoundTag nbt) {
        DataResult dataresult = ChargeCursor.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.cursors);
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.put("cursors", (Tag)nbtbase));
    }

    public void addCursors(BlockPos pos, int charge) {
        while (charge > 0) {
            int j = Math.min(charge, 1000);
            this.addCursor(new ChargeCursor(pos, j));
            charge -= j;
        }
    }

    private void addCursor(ChargeCursor cursor) {
        if (this.cursors.size() < 32) {
            if (!this.isWorldGeneration()) {
                CraftBlock bukkitBlock = CraftBlock.at(this.level, cursor.pos);
                SculkBloomEvent event = new SculkBloomEvent((org.bukkit.block.Block)bukkitBlock, cursor.getCharge());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                cursor.charge = event.getCharge();
            }
            this.cursors.add(cursor);
        }
    }

    public void updateCursors(LevelAccessor world, BlockPos pos, RandomSource random, boolean shouldConvertToBlock) {
        if (!this.cursors.isEmpty()) {
            BlockPos blockposition1;
            ArrayList<ChargeCursor> list = new ArrayList<ChargeCursor>();
            HashMap<BlockPos, ChargeCursor> map = new HashMap<BlockPos, ChargeCursor>();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            for (ChargeCursor sculkspreader_a : this.cursors) {
                sculkspreader_a.update(world, pos, random, this, shouldConvertToBlock);
                if (sculkspreader_a.charge <= 0) {
                    world.levelEvent(3006, sculkspreader_a.getPos(), 0);
                    continue;
                }
                blockposition1 = sculkspreader_a.getPos();
                object2intmap.computeInt((Object)blockposition1, (blockposition2, integer) -> (integer == null ? 0 : integer) + sculkspreader_a.charge);
                ChargeCursor sculkspreader_a1 = (ChargeCursor)map.get(blockposition1);
                if (sculkspreader_a1 == null) {
                    map.put(blockposition1, sculkspreader_a);
                    list.add(sculkspreader_a);
                    continue;
                }
                if (!this.isWorldGeneration() && sculkspreader_a.charge + sculkspreader_a1.charge <= 1000) {
                    sculkspreader_a1.mergeWith(sculkspreader_a);
                    continue;
                }
                list.add(sculkspreader_a);
                if (sculkspreader_a.charge >= sculkspreader_a1.charge) continue;
                map.put(blockposition1, sculkspreader_a);
            }
            for (Object2IntMap.Entry entry : object2intmap.object2IntEntrySet()) {
                Set<Direction> collection;
                blockposition1 = (BlockPos)entry.getKey();
                int i = entry.getIntValue();
                ChargeCursor sculkspreader_a2 = (ChargeCursor)map.get(blockposition1);
                Set<Direction> set = collection = sculkspreader_a2 == null ? null : sculkspreader_a2.getFacingData();
                if (i <= 0 || collection == null) continue;
                int j = (int)(Math.log1p(i) / (double)2.3f) + 1;
                int k = (j << 6) + MultifaceBlock.pack(collection);
                world.levelEvent(3006, blockposition1, k);
            }
            this.cursors = list;
        }
    }

    public static class ChargeCursor {
        private static final ObjectArrayList<Vec3i> NON_CORNER_NEIGHBOURS = Util.make(new ObjectArrayList(18), objectarraylist -> {
            Stream<BlockPos> stream = BlockPos.betweenClosedStream(new BlockPos(-1, -1, -1), new BlockPos(1, 1, 1)).filter(blockposition -> (blockposition.getX() == 0 || blockposition.getY() == 0 || blockposition.getZ() == 0) && !blockposition.equals(BlockPos.ZERO)).map(BlockPos::immutable);
            Objects.requireNonNull(objectarraylist);
            stream.forEach(arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        });
        public static final int MAX_CURSOR_DECAY_DELAY = 1;
        private BlockPos pos;
        int charge;
        private int updateDelay;
        private int decayDelay;
        @Nullable
        private Set<Direction> facings;
        private static final Codec<Set<Direction>> DIRECTION_SET = Direction.CODEC.listOf().xmap(list -> Sets.newEnumSet((Iterable)list, Direction.class), Lists::newArrayList);
        public static final Codec<ChargeCursor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(ChargeCursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(ChargeCursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(ChargeCursor::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(sculkspreader_a -> sculkspreader_a.updateDelay), (App)DIRECTION_SET.lenientOptionalFieldOf("facings").forGetter(sculkspreader_a -> Optional.ofNullable(sculkspreader_a.getFacingData()))).apply((Applicative)instance, ChargeCursor::new));

        private ChargeCursor(BlockPos pos, int charge, int decay, int update, Optional<Set<Direction>> faces) {
            this.pos = pos;
            this.charge = charge;
            this.decayDelay = decay;
            this.updateDelay = update;
            this.facings = faces.orElse(null);
        }

        public ChargeCursor(BlockPos pos, int charge) {
            this(pos, charge, 1, 0, Optional.empty());
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecayDelay() {
            return this.decayDelay;
        }

        @Nullable
        public Set<Direction> getFacingData() {
            return this.facings;
        }

        private boolean shouldUpdate(LevelAccessor world, BlockPos pos, boolean worldGen) {
            if (this.charge <= 0) {
                return false;
            }
            if (worldGen) {
                return true;
            }
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                return worldserver.shouldTickBlocksAt(pos);
            }
            return false;
        }

        public void update(LevelAccessor world, BlockPos pos, RandomSource random, SculkSpreader spreadManager, boolean shouldConvertToBlock) {
            if (this.shouldUpdate(world, pos, spreadManager.isWorldGeneration)) {
                if (this.updateDelay > 0) {
                    --this.updateDelay;
                } else {
                    BlockState iblockdata = world.getBlockState(this.pos);
                    SculkBehaviour sculkbehaviour = ChargeCursor.getBlockBehaviour(iblockdata);
                    if (shouldConvertToBlock && sculkbehaviour.attemptSpreadVein(world, this.pos, iblockdata, this.facings, spreadManager.isWorldGeneration())) {
                        if (sculkbehaviour.canChangeBlockStateOnSpread()) {
                            iblockdata = world.getBlockState(this.pos);
                            sculkbehaviour = ChargeCursor.getBlockBehaviour(iblockdata);
                        }
                        world.playSound(null, this.pos, SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    this.charge = sculkbehaviour.attemptUseCharge(this, world, pos, random, spreadManager, shouldConvertToBlock);
                    if (this.charge <= 0) {
                        sculkbehaviour.onDischarged(world, iblockdata, this.pos, random);
                    } else {
                        BlockPos blockposition1 = ChargeCursor.getValidMovementPos(world, this.pos, random);
                        if (blockposition1 != null) {
                            sculkbehaviour.onDischarged(world, iblockdata, this.pos, random);
                            this.pos = blockposition1.immutable();
                            if (spreadManager.isWorldGeneration() && !this.pos.closerThan(new Vec3i(pos.getX(), this.pos.getY(), pos.getZ()), 15.0)) {
                                this.charge = 0;
                                return;
                            }
                            iblockdata = world.getBlockState(blockposition1);
                        }
                        if (iblockdata.getBlock() instanceof SculkBehaviour) {
                            this.facings = MultifaceBlock.availableFaces(iblockdata);
                        }
                        this.decayDelay = sculkbehaviour.updateDecayDelay(this.decayDelay);
                        this.updateDelay = sculkbehaviour.getSculkSpreadDelay();
                    }
                }
            }
        }

        void mergeWith(ChargeCursor cursor) {
            this.charge += cursor.charge;
            cursor.charge = 0;
            this.updateDelay = Math.min(this.updateDelay, cursor.updateDelay);
        }

        private static SculkBehaviour getBlockBehaviour(BlockState state) {
            SculkBehaviour sculkbehaviour1;
            Block block = state.getBlock();
            SculkBehaviour sculkbehaviour = block instanceof SculkBehaviour ? (sculkbehaviour1 = (SculkBehaviour)((Object)block)) : SculkBehaviour.DEFAULT;
            return sculkbehaviour;
        }

        private static List<Vec3i> getRandomizedNonCornerNeighbourOffsets(RandomSource random) {
            return Util.shuffledCopy(NON_CORNER_NEIGHBOURS, random);
        }

        @Nullable
        private static BlockPos getValidMovementPos(LevelAccessor world, BlockPos pos, RandomSource random) {
            BlockPos.MutableBlockPos blockposition_mutableblockposition = pos.mutable();
            BlockPos.MutableBlockPos blockposition_mutableblockposition1 = pos.mutable();
            for (Vec3i baseblockposition : ChargeCursor.getRandomizedNonCornerNeighbourOffsets(random)) {
                blockposition_mutableblockposition1.setWithOffset((Vec3i)pos, baseblockposition);
                BlockState iblockdata = world.getBlockState(blockposition_mutableblockposition1);
                if (!(iblockdata.getBlock() instanceof SculkBehaviour) || !ChargeCursor.isMovementUnobstructed(world, pos, blockposition_mutableblockposition1)) continue;
                blockposition_mutableblockposition.set(blockposition_mutableblockposition1);
                if (!SculkVeinBlock.hasSubstrateAccess(world, iblockdata, blockposition_mutableblockposition1)) continue;
                break;
            }
            return blockposition_mutableblockposition.equals(pos) ? null : blockposition_mutableblockposition;
        }

        private static boolean isMovementUnobstructed(LevelAccessor world, BlockPos sourcePos, BlockPos targetPos) {
            if (sourcePos.distManhattan(targetPos) == 1) {
                return true;
            }
            BlockPos blockposition2 = targetPos.subtract(sourcePos);
            Direction enumdirection = Direction.fromAxisAndDirection(Direction.Axis.X, blockposition2.getX() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
            Direction enumdirection1 = Direction.fromAxisAndDirection(Direction.Axis.Y, blockposition2.getY() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
            Direction enumdirection2 = Direction.fromAxisAndDirection(Direction.Axis.Z, blockposition2.getZ() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
            return blockposition2.getX() == 0 ? ChargeCursor.isUnobstructed(world, sourcePos, enumdirection1) || ChargeCursor.isUnobstructed(world, sourcePos, enumdirection2) : (blockposition2.getY() == 0 ? ChargeCursor.isUnobstructed(world, sourcePos, enumdirection) || ChargeCursor.isUnobstructed(world, sourcePos, enumdirection2) : ChargeCursor.isUnobstructed(world, sourcePos, enumdirection) || ChargeCursor.isUnobstructed(world, sourcePos, enumdirection1));
        }

        private static boolean isUnobstructed(LevelAccessor world, BlockPos pos, Direction direction) {
            BlockPos blockposition1 = pos.relative(direction);
            return !world.getBlockState(blockposition1).isFaceSturdy(world, blockposition1, direction.getOpposite());
        }
    }
}

