/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.ItemLike;

public interface SuspiciousEffectHolder {
    public SuspiciousStewEffects getSuspiciousEffects();

    public static List<SuspiciousEffectHolder> getAllEffectHolders() {
        return BuiltInRegistries.ITEM.stream().map(SuspiciousEffectHolder::tryGet).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public static SuspiciousEffectHolder tryGet(ItemLike item) {
        BlockItem blockItem;
        FeatureElement featureElement = item.asItem();
        if (featureElement instanceof BlockItem && (featureElement = (blockItem = (BlockItem)featureElement).getBlock()) instanceof SuspiciousEffectHolder) {
            SuspiciousEffectHolder suspiciousEffectHolder = (SuspiciousEffectHolder)((Object)featureElement);
            return suspiciousEffectHolder;
        }
        Item item2 = item.asItem();
        if (item2 instanceof SuspiciousEffectHolder) {
            SuspiciousEffectHolder suspiciousEffectHolder2 = (SuspiciousEffectHolder)((Object)item2);
            return suspiciousEffectHolder2;
        }
        return null;
    }
}

