/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.entity.Entity;

public class WebBlock
extends Block {
    public static final MapCodec<WebBlock> CODEC = WebBlock.simpleCodec(WebBlock::new);

    public MapCodec<WebBlock> codec() {
        return CODEC;
    }

    public WebBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    protected void entityInside(BlockState state, Level world, BlockPos pos, net.minecraft.world.entity.Entity entity) {
        LivingEntity livingEntity;
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        Vec3 vec3 = new Vec3(0.25, 0.05f, 0.25);
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(MobEffects.WEAVING)) {
            vec3 = new Vec3(0.5, 0.25, 0.5);
        }
        entity.makeStuckInBlock(state, vec3);
    }
}

