/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.block.CampfireStartEvent;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public class CampfireBlockEntity
extends BlockEntity
implements Clearable {
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private final NonNullList<net.minecraft.world.item.ItemStack> items = NonNullList.withSize(4, net.minecraft.world.item.ItemStack.EMPTY);
    public final int[] cookingProgress = new int[4];
    public final int[] cookingTime = new int[4];
    private final RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> quickCheck = RecipeManager.createCheck(RecipeType.CAMPFIRE_COOKING);
    public final boolean[] stopCooking = new boolean[4];

    public CampfireBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityType.CAMPFIRE, pos, state);
    }

    public static void cookTick(Level world, BlockPos pos, BlockState state, CampfireBlockEntity campfire) {
        boolean flag = false;
        for (int i = 0; i < campfire.items.size(); ++i) {
            SingleRecipeInput singlerecipeinput;
            Optional<RecipeHolder<CampfireCookingRecipe>> recipeHolderOptional;
            net.minecraft.world.item.ItemStack itemstack1;
            net.minecraft.world.item.ItemStack itemstack = campfire.items.get(i);
            if (itemstack.isEmpty()) continue;
            flag = true;
            if (!campfire.stopCooking[i]) {
                int n = i;
                campfire.cookingProgress[n] = campfire.cookingProgress[n] + 1;
            }
            if (campfire.cookingProgress[i] < campfire.cookingTime[i] || !(itemstack1 = (recipeHolderOptional = campfire.quickCheck.getRecipeFor(singlerecipeinput = new SingleRecipeInput(itemstack), world)).map(recipeholder -> ((CampfireCookingRecipe)recipeholder.value()).assemble(singlerecipeinput, (HolderLookup.Provider)world.registryAccess())).orElse(itemstack)).isItemEnabled(world.enabledFeatures())) continue;
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            BlockCookEvent blockCookEvent = new BlockCookEvent((Block)CraftBlock.at(world, pos), (ItemStack)source, result, (CookingRecipe)recipeHolderOptional.map(RecipeHolder::toBukkitRecipe).orElse(null));
            world.getCraftServer().getPluginManager().callEvent((Event)blockCookEvent);
            if (blockCookEvent.isCancelled()) {
                return;
            }
            result = blockCookEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            double deviation = 0.11485000171139836;
            while (!itemstack1.isEmpty()) {
                ItemEntity droppedItem = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack1.split(world.random.nextInt(21) + 10));
                droppedItem.setDeltaMovement(world.random.triangle(0.0, deviation), world.random.triangle(0.2, deviation), world.random.triangle(0.0, deviation));
                world.addFreshEntity(droppedItem);
            }
            campfire.items.set(i, net.minecraft.world.item.ItemStack.EMPTY);
            world.sendBlockUpdated(pos, state, state, 3);
            world.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of(state));
        }
        if (flag) {
            CampfireBlockEntity.setChanged(world, pos, state);
        }
    }

    public static void cooldownTick(Level world, BlockPos pos, BlockState state, CampfireBlockEntity campfire) {
        boolean flag = false;
        for (int i = 0; i < campfire.items.size(); ++i) {
            if (campfire.cookingProgress[i] <= 0) continue;
            flag = true;
            campfire.cookingProgress[i] = Mth.clamp(campfire.cookingProgress[i] - 2, 0, campfire.cookingTime[i]);
        }
        if (flag) {
            CampfireBlockEntity.setChanged(world, pos, state);
        }
    }

    public static void particleTick(Level world, BlockPos pos, BlockState state, CampfireBlockEntity campfire) {
        int i;
        RandomSource randomsource = world.random;
        if (randomsource.nextFloat() < 0.11f) {
            for (i = 0; i < randomsource.nextInt(2) + 2; ++i) {
                CampfireBlock.makeParticles(world, pos, state.getValue(CampfireBlock.SIGNAL_FIRE), false);
            }
        }
        i = state.getValue(CampfireBlock.FACING).get2DDataValue();
        for (int j = 0; j < campfire.items.size(); ++j) {
            if (campfire.items.get(j).isEmpty() || !(randomsource.nextFloat() < 0.2f)) continue;
            Direction enumdirection = Direction.from2DDataValue(Math.floorMod(j + i, 4));
            float f = 0.3125f;
            double d0 = (double)pos.getX() + 0.5 - (double)((float)enumdirection.getStepX() * 0.3125f) + (double)((float)enumdirection.getClockWise().getStepX() * 0.3125f);
            double d1 = (double)pos.getY() + 0.5;
            double d2 = (double)pos.getZ() + 0.5 - (double)((float)enumdirection.getStepZ() * 0.3125f) + (double)((float)enumdirection.getClockWise().getStepZ() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                world.addParticle(ParticleTypes.SMOKE, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        int[] aint;
        super.loadAdditional(nbt, registryLookup);
        this.items.clear();
        ContainerHelper.loadAllItems(nbt, this.items, registryLookup);
        if (nbt.contains("CookingTimes", 11)) {
            aint = nbt.getIntArray("CookingTimes");
            System.arraycopy(aint, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, aint.length));
        }
        if (nbt.contains("CookingTotalTimes", 11)) {
            aint = nbt.getIntArray("CookingTotalTimes");
            System.arraycopy(aint, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, aint.length));
        }
        if (nbt.contains("Paper.StopCooking", 7)) {
            byte[] abyte = nbt.getByteArray("Paper.StopCooking");
            boolean[] cookingState = new boolean[4];
            for (int index = 0; index < abyte.length; ++index) {
                cookingState[index] = abyte[index] == 1;
            }
            System.arraycopy(cookingState, 0, this.stopCooking, 0, Math.min(this.stopCooking.length, abyte.length));
        }
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems(nbt, this.items, true, registryLookup);
        nbt.putIntArray("CookingTimes", this.cookingProgress);
        nbt.putIntArray("CookingTotalTimes", this.cookingTime);
        byte[] cookingState = new byte[4];
        for (int index = 0; index < cookingState.length; ++index) {
            cookingState[index] = (byte)(this.stopCooking[index] ? 1 : 0);
        }
        nbt.putByteArray("Paper.StopCooking", cookingState);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbttagcompound = new CompoundTag();
        ContainerHelper.saveAllItems(nbttagcompound, this.items, true, registryLookup);
        return nbttagcompound;
    }

    public Optional<RecipeHolder<CampfireCookingRecipe>> getCookableRecipe(net.minecraft.world.item.ItemStack stack) {
        return this.items.stream().noneMatch(net.minecraft.world.item.ItemStack::isEmpty) ? Optional.empty() : this.quickCheck.getRecipeFor(new SingleRecipeInput(stack), this.level);
    }

    public boolean placeFood(@Nullable LivingEntity user, net.minecraft.world.item.ItemStack stack, int cookTime) {
        for (int j = 0; j < this.items.size(); ++j) {
            net.minecraft.world.item.ItemStack itemstack1 = this.items.get(j);
            if (!itemstack1.isEmpty()) continue;
            CampfireStartEvent event = new CampfireStartEvent((Block)CraftBlock.at(this.level, this.worldPosition), (ItemStack)CraftItemStack.asCraftMirror(stack), (CampfireRecipe)this.getCookableRecipe(stack).get().toBukkitRecipe());
            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
            this.cookingTime[j] = event.getTotalCookTime();
            this.cookingProgress[j] = 0;
            this.items.set(j, stack.consumeAndReturn(1, user));
            this.level.gameEvent(GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of(user, this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    @Override
    public void clearContent() {
        this.items.clear();
    }

    public void dowse() {
        if (this.level != null) {
            this.markUpdated();
        }
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        components.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).copyInto(this.getItems());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder componentMapBuilder) {
        super.collectImplicitComponents(componentMapBuilder);
        componentMapBuilder.set(DataComponents.CONTAINER, ItemContainerContents.fromItems(this.getItems()));
    }

    @Override
    public void removeComponentsFromTag(CompoundTag nbt) {
        nbt.remove("Items");
    }
}

