/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public final class TrialSpawner {
    public static final String NORMAL_CONFIG_TAG_NAME = "normal_config";
    public static final String OMINOUS_CONFIG_TAG_NAME = "ominous_config";
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int DEFAULT_TARGET_COOLDOWN_LENGTH = 36000;
    private static final int DEFAULT_PLAYER_SCAN_RANGE = 14;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = Mth.square(47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    public TrialSpawnerConfig normalConfig;
    public TrialSpawnerConfig ominousConfig;
    private final TrialSpawnerData data;
    public int requiredPlayerRange;
    public int targetCooldownLength;
    public final StateAccessor stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.EntitySelector entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;
    public boolean isOminous;

    public Codec<TrialSpawner> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)TrialSpawnerConfig.CODEC.optionalFieldOf(NORMAL_CONFIG_TAG_NAME, (Object)TrialSpawnerConfig.DEFAULT).forGetter(TrialSpawner::getNormalConfig), (App)TrialSpawnerConfig.CODEC.optionalFieldOf(OMINOUS_CONFIG_TAG_NAME, (Object)TrialSpawnerConfig.DEFAULT).forGetter(TrialSpawner::getOminousConfigForSerialization), (App)TrialSpawnerData.MAP_CODEC.forGetter(TrialSpawner::getData), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(TrialSpawner::getTargetCooldownLength), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(TrialSpawner::getRequiredPlayerRange)).apply((Applicative)instance, (trialspawnerconfig, trialspawnerconfig1, trialspawnerdata, integer, integer1) -> new TrialSpawner((TrialSpawnerConfig)trialspawnerconfig, (TrialSpawnerConfig)trialspawnerconfig1, (TrialSpawnerData)trialspawnerdata, (int)integer, (int)integer1, this.stateAccessor, this.playerDetector, this.entitySelector)));
    }

    public TrialSpawner(StateAccessor trialSpawner, PlayerDetector entityDetector, PlayerDetector.EntitySelector entitySelector) {
        this(TrialSpawnerConfig.DEFAULT, TrialSpawnerConfig.DEFAULT, new TrialSpawnerData(), 36000, 14, trialSpawner, entityDetector, entitySelector);
    }

    public TrialSpawner(TrialSpawnerConfig normalConfig, TrialSpawnerConfig ominousConfig, TrialSpawnerData data, int cooldownLength, int entityDetectionRange, StateAccessor trialSpawner, PlayerDetector entityDetector, PlayerDetector.EntitySelector entitySelector) {
        this.normalConfig = normalConfig;
        this.ominousConfig = ominousConfig;
        this.data = data;
        this.targetCooldownLength = cooldownLength;
        this.requiredPlayerRange = entityDetectionRange;
        this.stateAccessor = trialSpawner;
        this.playerDetector = entityDetector;
        this.entitySelector = entitySelector;
    }

    public TrialSpawnerConfig getConfig() {
        return this.isOminous ? this.ominousConfig : this.normalConfig;
    }

    @VisibleForTesting
    public TrialSpawnerConfig getNormalConfig() {
        return this.normalConfig;
    }

    @VisibleForTesting
    public TrialSpawnerConfig getOminousConfig() {
        return this.ominousConfig;
    }

    private TrialSpawnerConfig getOminousConfigForSerialization() {
        return !this.ominousConfig.equals(this.normalConfig) ? this.ominousConfig : TrialSpawnerConfig.DEFAULT;
    }

    public void applyOminous(ServerLevel world, BlockPos pos) {
        world.setBlock(pos, (BlockState)world.getBlockState(pos).setValue(TrialSpawnerBlock.OMINOUS, true), 3);
        world.levelEvent(3020, pos, 1);
        this.isOminous = true;
        this.data.resetAfterBecomingOminous(this, world);
    }

    public void removeOminous(ServerLevel world, BlockPos pos) {
        world.setBlock(pos, (BlockState)world.getBlockState(pos).setValue(TrialSpawnerBlock.OMINOUS, false), 3);
        this.isOminous = false;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public TrialSpawnerData getData() {
        return this.data;
    }

    public int getTargetCooldownLength() {
        return this.targetCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public void setState(Level world, TrialSpawnerState spawnerState) {
        this.stateAccessor.setState(world, spawnerState);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(Level world) {
        return this.overridePeacefulAndMobSpawnRule ? true : (world.getDifficulty() == Difficulty.PEACEFUL ? false : world.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING));
    }

    public Optional<UUID> spawnMob(ServerLevel world, BlockPos pos) {
        SpawnData.CustomSpawnRules mobspawnerdata_a;
        double d2;
        RandomSource randomsource = world.getRandom();
        SpawnData mobspawnerdata = this.data.getOrCreateNextSpawnData(this, world.getRandom());
        CompoundTag nbttagcompound = mobspawnerdata.entityToSpawn();
        ListTag nbttaglist = nbttagcompound.getList("Pos", 6);
        Optional<EntityType<?>> optional = EntityType.by(nbttagcompound);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        int i = nbttaglist.size();
        double d0 = i >= 1 ? nbttaglist.getDouble(0) : (double)pos.getX() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5;
        double d1 = i >= 2 ? nbttaglist.getDouble(1) : (double)(pos.getY() + randomsource.nextInt(3) - 1);
        double d = d2 = i >= 3 ? nbttaglist.getDouble(2) : (double)pos.getZ() + (randomsource.nextDouble() - randomsource.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5;
        if (!world.noCollision(optional.get().getSpawnAABB(d0, d1, d2))) {
            return Optional.empty();
        }
        Vec3 vec3d = new Vec3(d0, d1, d2);
        if (!TrialSpawner.inLineOfSight(world, pos.getCenter(), vec3d)) {
            return Optional.empty();
        }
        BlockPos blockposition1 = BlockPos.containing(vec3d);
        if (!SpawnPlacements.checkSpawnRules(optional.get(), world, MobSpawnType.TRIAL_SPAWNER, blockposition1, world.getRandom())) {
            return Optional.empty();
        }
        if (mobspawnerdata.getCustomSpawnRules().isPresent() && !(mobspawnerdata_a = mobspawnerdata.getCustomSpawnRules().get()).isValidPosition(blockposition1, world)) {
            return Optional.empty();
        }
        Entity entity = EntityType.loadEntityRecursive(nbttagcompound, world, entity1 -> {
            entity1.moveTo(d0, d1, d2, randomsource.nextFloat() * 360.0f, 0.0f);
            return entity1;
        });
        if (entity == null) {
            return Optional.empty();
        }
        if (entity instanceof Mob) {
            boolean flag;
            Mob entityinsentient = (Mob)entity;
            if (!entityinsentient.checkSpawnObstruction(world)) {
                return Optional.empty();
            }
            boolean bl = flag = mobspawnerdata.getEntityToSpawn().size() == 1 && mobspawnerdata.getEntityToSpawn().contains("id", 8);
            if (flag) {
                entityinsentient.finalizeSpawn(world, world.getCurrentDifficultyAt(entityinsentient.blockPosition()), MobSpawnType.TRIAL_SPAWNER, null);
            }
            entityinsentient.setPersistenceRequired();
            Optional<EquipmentTable> optional1 = mobspawnerdata.getEquipment();
            Objects.requireNonNull(entityinsentient);
            optional1.ifPresent(entityinsentient::equip);
        }
        if (CraftEventFactory.callTrialSpawnerSpawnEvent(entity, pos).isCancelled()) {
            return Optional.empty();
        }
        if (!world.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER)) {
            return Optional.empty();
        }
        FlameParticle trialspawner_a = this.isOminous ? FlameParticle.OMINOUS : FlameParticle.NORMAL;
        world.levelEvent(3011, pos, trialspawner_a.encode());
        world.levelEvent(3012, blockposition1, trialspawner_a.encode());
        world.gameEvent(entity, GameEvent.ENTITY_PLACE, blockposition1);
        return Optional.of(entity.getUUID());
    }

    public void ejectReward(ServerLevel world, BlockPos pos, ResourceKey<LootTable> lootTable) {
        LootParams lootparams;
        LootTable loottable = world.getServer().reloadableRegistries().getLootTable(lootTable);
        ObjectArrayList<ItemStack> objectarraylist = loottable.getRandomItems(lootparams = new LootParams.Builder(world).create(LootContextParamSets.EMPTY));
        if (!objectarraylist.isEmpty()) {
            for (ItemStack itemstack : objectarraylist) {
                DefaultDispenseItemBehavior.spawnItem(world, itemstack, 2, Direction.UP, Vec3.atBottomCenterOf(pos).relative(Direction.UP, 1.2));
            }
            world.levelEvent(3014, pos, 0);
        }
    }

    public void tickClient(Level world, BlockPos pos, boolean ominous) {
        RandomSource randomsource;
        TrialSpawnerState trialspawnerstate = this.getState();
        trialspawnerstate.emitParticles(world, pos, ominous);
        if (trialspawnerstate.hasSpinningMob()) {
            double d0 = Math.max(0L, this.data.nextMobSpawnsAt - world.getGameTime());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + trialspawnerstate.spinningMobSpeed() / (d0 + 200.0)) % 360.0;
        }
        if (trialspawnerstate.isCapableOfSpawning() && (randomsource = world.getRandom()).nextFloat() <= 0.02f) {
            SoundEvent soundeffect = ominous ? SoundEvents.TRIAL_SPAWNER_AMBIENT_OMINOUS : SoundEvents.TRIAL_SPAWNER_AMBIENT;
            world.playLocalSound(pos, soundeffect, SoundSource.BLOCKS, randomsource.nextFloat() * 0.25f + 0.75f, randomsource.nextFloat() + 0.5f, false);
        }
    }

    public void tickServer(ServerLevel world, BlockPos pos, boolean ominous) {
        TrialSpawnerState trialspawnerstate1;
        this.isOminous = ominous;
        TrialSpawnerState trialspawnerstate = this.getState();
        if (this.data.currentMobs.removeIf(uuid -> TrialSpawner.shouldMobBeUntracked(world, pos, uuid))) {
            this.data.nextMobSpawnsAt = world.getGameTime() + (long)this.getConfig().ticksBetweenSpawn();
        }
        if ((trialspawnerstate1 = trialspawnerstate.tickAndGetNext(pos, this, world)) != trialspawnerstate) {
            this.setState(world, trialspawnerstate1);
        }
    }

    private static boolean shouldMobBeUntracked(ServerLevel world, BlockPos pos, UUID uuid) {
        Entity entity = world.getEntity(uuid);
        return entity == null || !entity.isAlive() || !entity.level().dimension().equals(world.dimension()) || entity.blockPosition().distSqr(pos) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(Level world, Vec3 spawnerPos, Vec3 spawnPos) {
        BlockHitResult movingobjectpositionblock = world.clip(new ClipContext(spawnPos, spawnerPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return movingobjectpositionblock.getBlockPos().equals(BlockPos.containing(spawnerPos)) || movingobjectpositionblock.getType() == HitResult.Type.MISS;
    }

    public static void addSpawnParticles(Level world, BlockPos pos, RandomSource random, SimpleParticleType particle) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double d1 = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double d2 = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            world.addParticle(ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            world.addParticle(particle, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void addBecomeOminousParticles(Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double d1 = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double d2 = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 2.0;
            double d3 = random.nextGaussian() * 0.02;
            double d4 = random.nextGaussian() * 0.02;
            double d5 = random.nextGaussian() * 0.02;
            world.addParticle(ParticleTypes.TRIAL_OMEN, d0, d1, d2, d3, d4, d5);
            world.addParticle(ParticleTypes.SOUL_FIRE_FLAME, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void addDetectPlayerParticles(Level world, BlockPos pos, RandomSource random, int playerCount, ParticleOptions particle) {
        for (int j = 0; j < 30 + Math.min(playerCount, 10) * 5; ++j) {
            double d0 = (double)(2.0f * random.nextFloat() - 1.0f) * 0.65;
            double d1 = (double)(2.0f * random.nextFloat() - 1.0f) * 0.65;
            double d2 = (double)pos.getX() + 0.5 + d0;
            double d3 = (double)pos.getY() + 0.1 + (double)random.nextFloat() * 0.8;
            double d4 = (double)pos.getZ() + 0.5 + d1;
            world.addParticle(particle, d2, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(Level world, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)pos.getX() + 0.4 + random.nextDouble() * 0.2;
            double d1 = (double)pos.getY() + 0.4 + random.nextDouble() * 0.2;
            double d2 = (double)pos.getZ() + 0.4 + random.nextDouble() * 0.2;
            double d3 = random.nextGaussian() * 0.02;
            double d4 = random.nextGaussian() * 0.02;
            double d5 = random.nextGaussian() * 0.02;
            world.addParticle(ParticleTypes.SMALL_FLAME, d0, d1, d2, d3, d4, d5 * 0.25);
            world.addParticle(ParticleTypes.SMOKE, d0, d1, d2, d3, d4, d5);
        }
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector detector) {
        this.playerDetector = detector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    public static interface StateAccessor {
        public void setState(Level var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }

    public static enum FlameParticle {
        NORMAL(ParticleTypes.FLAME),
        OMINOUS(ParticleTypes.SOUL_FIRE_FLAME);

        public final SimpleParticleType particleType;

        private FlameParticle(SimpleParticleType particletype) {
            this.particleType = particletype;
        }

        public static FlameParticle decode(int index) {
            FlameParticle[] atrialspawner_a = FlameParticle.values();
            return index <= atrialspawner_a.length && index >= 0 ? atrialspawner_a[index] : NORMAL;
        }

        public int encode() {
            return this.ordinal();
        }
    }
}

