/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.Property;

public class EnumProperty<T extends Enum<T>>
extends Property<T> {
    private final ImmutableSet<T> values;
    private final Map<String, T> names = Maps.newHashMap();
    private int[] idLookupTable;

    @Override
    public final int getIdFor(T value) {
        return this.idLookupTable[((Enum)value).ordinal()];
    }

    protected EnumProperty(String name, Class<T> type, Collection<T> values) {
        super(name, type);
        this.values = ImmutableSet.copyOf(values);
        for (Enum enum_ : values) {
            String string = ((StringRepresentable)((Object)enum_)).getSerializedName();
            if (this.names.containsKey(string)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + string + "'");
            }
            this.names.put(string, enum_);
        }
        int id = 0;
        this.idLookupTable = new int[((Enum[])type.getEnumConstants()).length];
        Arrays.fill(this.idLookupTable, -1);
        for (Enum value : this.getPossibleValues()) {
            this.idLookupTable[value.ordinal()] = id++;
        }
    }

    @Override
    public Collection<T> getPossibleValues() {
        return this.values;
    }

    @Override
    public Optional<T> getValue(String name) {
        return Optional.ofNullable((Enum)this.names.get(name));
    }

    @Override
    public String getName(T value) {
        return ((StringRepresentable)value).getSerializedName();
    }

    public boolean equals_unused(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EnumProperty) {
            EnumProperty enumProperty = (EnumProperty)object;
            if (super.equals(object)) {
                return this.values.equals(enumProperty.values) && this.names.equals(enumProperty.names);
            }
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        int i = super.generateHashCode();
        i = 31 * i + this.values.hashCode();
        return 31 * i + this.names.hashCode();
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> type) {
        return EnumProperty.create(name, type, (T enum_) -> true);
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> type, Predicate<T> filter) {
        return EnumProperty.create(name, type, Arrays.stream((Enum[])type.getEnumConstants()).filter(filter).collect(Collectors.toList()));
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> type, T ... values) {
        return EnumProperty.create(name, type, Lists.newArrayList((Object[])values));
    }

    public static <T extends Enum<T>> EnumProperty<T> create(String name, Class<T> type, Collection<T> values) {
        return new EnumProperty<T>(name, type, values);
    }
}

