/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.world.level.block.state.properties.Property;

public class IntegerProperty
extends Property<Integer> {
    private final ImmutableSet<Integer> values;
    public final int min;
    public final int max;

    @Override
    public final int getIdFor(Integer value) {
        int val = value;
        int ret = val - this.min;
        return ret | this.max - ret >> 31;
    }

    protected IntegerProperty(String name, int min, int max) {
        super(name, Integer.class);
        if (min < 0) {
            throw new IllegalArgumentException("Min value of " + name + " must be 0 or greater");
        }
        if (max <= min) {
            throw new IllegalArgumentException("Max value of " + name + " must be greater than min (" + min + ")");
        }
        this.min = min;
        this.max = max;
        HashSet set = Sets.newHashSet();
        for (int i = min; i <= max; ++i) {
            set.add(i);
        }
        this.values = ImmutableSet.copyOf((Collection)set);
    }

    @Override
    public Collection<Integer> getPossibleValues() {
        return this.values;
    }

    public boolean equals_unused(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IntegerProperty) {
            IntegerProperty integerProperty = (IntegerProperty)object;
            if (super.equals(object)) {
                return this.values.equals(integerProperty.values);
            }
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        return 31 * super.generateHashCode() + this.values.hashCode();
    }

    public static IntegerProperty create(String name, int min, int max) {
        return new IntegerProperty(name, min, max);
    }

    @Override
    public Optional<Integer> getValue(String name) {
        try {
            Integer integer = Integer.valueOf(name);
            return integer >= this.min && integer <= this.max ? Optional.of(integer) : Optional.empty();
        }
        catch (NumberFormatException var3) {
            return Optional.empty();
        }
    }

    @Override
    public String getName(Integer value) {
        return value.toString();
    }
}

