/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;

public class DeltaFeature
extends Feature<DeltaFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_REPLACE = ImmutableList.of((Object)Blocks.BEDROCK, (Object)Blocks.NETHER_BRICKS, (Object)Blocks.NETHER_BRICK_FENCE, (Object)Blocks.NETHER_BRICK_STAIRS, (Object)Blocks.NETHER_WART, (Object)Blocks.CHEST, (Object)Blocks.SPAWNER);
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final double RIM_SPAWN_CHANCE = 0.9;

    public DeltaFeature(Codec<DeltaFeatureConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean place(FeaturePlaceContext<DeltaFeatureConfiguration> context) {
        boolean bl = false;
        RandomSource randomSource = context.random();
        WorldGenLevel worldGenLevel = context.level();
        DeltaFeatureConfiguration deltaFeatureConfiguration = context.config();
        BlockPos blockPos = context.origin();
        boolean bl2 = randomSource.nextDouble() < 0.9;
        int i = bl2 ? deltaFeatureConfiguration.rimSize().sample(randomSource) : 0;
        int j = bl2 ? deltaFeatureConfiguration.rimSize().sample(randomSource) : 0;
        boolean bl3 = bl2 && i != 0 && j != 0;
        int k = deltaFeatureConfiguration.size().sample(randomSource);
        int l = deltaFeatureConfiguration.size().sample(randomSource);
        int m = Math.max(k, l);
        for (BlockPos blockPos2 : BlockPos.withinManhattan(blockPos, k, 0, l)) {
            BlockPos blockPos3;
            if (blockPos2.distManhattan(blockPos) > m) break;
            if (!DeltaFeature.isClear(worldGenLevel, blockPos2, deltaFeatureConfiguration)) continue;
            if (bl3) {
                bl = true;
                this.setBlock(worldGenLevel, blockPos2, deltaFeatureConfiguration.rim());
            }
            if (!DeltaFeature.isClear(worldGenLevel, blockPos3 = blockPos2.offset(i, 0, j), deltaFeatureConfiguration)) continue;
            bl = true;
            this.setBlock(worldGenLevel, blockPos3, deltaFeatureConfiguration.contents());
        }
        return bl;
    }

    private static boolean isClear(LevelAccessor world, BlockPos pos, DeltaFeatureConfiguration config) {
        BlockState blockState = world.getBlockState(pos);
        if (blockState.is(config.contents().getBlock())) {
            return false;
        }
        if (CANNOT_REPLACE.contains((Object)blockState.getBlock())) {
            return false;
        }
        for (Direction direction : DIRECTIONS) {
            boolean bl = world.getBlockState(pos.relative(direction)).isAir();
            if ((!bl || direction == Direction.UP) && (bl || direction != Direction.UP)) continue;
            return false;
        }
        return true;
    }
}

