/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class EndPlatformFeature
extends Feature<NoneFeatureConfiguration> {
    public EndPlatformFeature(Codec<NoneFeatureConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        EndPlatformFeature.createEndPlatform(context.level(), context.origin(), false);
        return true;
    }

    public static void createEndPlatform(ServerLevelAccessor world, BlockPos pos, boolean breakBlocks) {
        EndPlatformFeature.createEndPlatform(world, pos, breakBlocks, null);
    }

    public static void createEndPlatform(ServerLevelAccessor worldaccess, BlockPos blockposition, boolean flag, net.minecraft.world.entity.Entity entity) {
        BlockStateListPopulator blockList = new BlockStateListPopulator(worldaccess);
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -1; k < 3; ++k) {
                    Block block;
                    BlockPos.MutableBlockPos blockposition_mutableblockposition1 = blockposition_mutableblockposition.set(blockposition).move(j, k, i);
                    Block block2 = block = k == -1 ? Blocks.OBSIDIAN : Blocks.AIR;
                    if (blockList.getBlockState(blockposition_mutableblockposition1).is(block)) continue;
                    if (flag) {
                        blockList.destroyBlock(blockposition_mutableblockposition1, true, null);
                    }
                    blockList.setBlock(blockposition_mutableblockposition1, block.defaultBlockState(), 3);
                }
            }
        }
        if (entity == null) {
            blockList.updateList();
            return;
        }
        CraftWorld bworld = worldaccess.getLevel().getWorld();
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)entity.getBukkitEntity(), PortalCreateEvent.CreateReason.END_PLATFORM);
        worldaccess.getLevel().getCraftServer().getPluginManager().callEvent((Event)portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }
}

