/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.slf4j.Logger;

public class MonsterRoomFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityType<?>[] MOBS = new EntityType[]{EntityType.SKELETON, EntityType.ZOMBIE, EntityType.ZOMBIE, EntityType.SPIDER};
    private static final BlockState AIR = Blocks.CAVE_AIR.defaultBlockState();

    public MonsterRoomFeature(Codec<NoneFeatureConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        Predicate<BlockState> predicate = Feature.isReplaceable(BlockTags.FEATURES_CANNOT_REPLACE);
        BlockPos blockPos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel worldGenLevel = context.level();
        int i = 3;
        int j = randomSource.nextInt(2) + 2;
        int k = -j - 1;
        int l = j + 1;
        int m = -1;
        int n = 4;
        int o = randomSource.nextInt(2) + 2;
        int p = -o - 1;
        int q = o + 1;
        int r = 0;
        for (int s = k; s <= l; ++s) {
            for (int t = -1; t <= 4; ++t) {
                for (int u = p; u <= q; ++u) {
                    BlockPos blockPos2 = blockPos.offset(s, t, u);
                    boolean bl = worldGenLevel.getBlockState(blockPos2).isSolid();
                    if (t == -1 && !bl) {
                        return false;
                    }
                    if (t == 4 && !bl) {
                        return false;
                    }
                    if (s != k && s != l && u != p && u != q || t != 0 || !worldGenLevel.isEmptyBlock(blockPos2) || !worldGenLevel.isEmptyBlock(blockPos2.above())) continue;
                    ++r;
                }
            }
        }
        if (r < 1 || r > 5) {
            return false;
        }
        for (int v = k; v <= l; ++v) {
            for (int w = 3; w >= -1; --w) {
                for (int x = p; x <= q; ++x) {
                    BlockPos blockPos3 = blockPos.offset(v, w, x);
                    BlockState blockState = worldGenLevel.getBlockState(blockPos3);
                    if (v == k || w == -1 || x == p || v == l || w == 4 || x == q) {
                        if (blockPos3.getY() >= worldGenLevel.getMinBuildHeight() && !worldGenLevel.getBlockState(blockPos3.below()).isSolid()) {
                            worldGenLevel.setBlock(blockPos3, AIR, 2);
                            continue;
                        }
                        if (!blockState.isSolid() || blockState.is(Blocks.CHEST)) continue;
                        if (w == -1 && randomSource.nextInt(4) != 0) {
                            this.safeSetBlock(worldGenLevel, blockPos3, Blocks.MOSSY_COBBLESTONE.defaultBlockState(), predicate);
                            continue;
                        }
                        this.safeSetBlock(worldGenLevel, blockPos3, Blocks.COBBLESTONE.defaultBlockState(), predicate);
                        continue;
                    }
                    if (blockState.is(Blocks.CHEST) || blockState.is(Blocks.SPAWNER)) continue;
                    this.safeSetBlock(worldGenLevel, blockPos3, AIR, predicate);
                }
            }
        }
        block6: for (int y = 0; y < 2; ++y) {
            for (int z = 0; z < 3; ++z) {
                int ac;
                int ab;
                int aa = blockPos.getX() + randomSource.nextInt(j * 2 + 1) - j;
                BlockPos blockPos4 = new BlockPos(aa, ab = blockPos.getY(), ac = blockPos.getZ() + randomSource.nextInt(o * 2 + 1) - o);
                if (!worldGenLevel.isEmptyBlock(blockPos4)) continue;
                int ad = 0;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (!worldGenLevel.getBlockState(blockPos4.relative(direction)).isSolid()) continue;
                    ++ad;
                }
                if (ad != 1) continue;
                this.safeSetBlock(worldGenLevel, blockPos4, StructurePiece.reorient(worldGenLevel, blockPos4, Blocks.CHEST.defaultBlockState()), predicate);
                RandomizableContainer.setBlockEntityLootTable(worldGenLevel, randomSource, blockPos4, BuiltInLootTables.SIMPLE_DUNGEON);
                continue block6;
            }
        }
        this.safeSetBlock(worldGenLevel, blockPos, Blocks.SPAWNER.defaultBlockState(), predicate);
        BlockEntity blockEntity = worldGenLevel.getBlockEntity(blockPos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            spawnerBlockEntity.setEntityId(this.randomEntityId(randomSource), randomSource);
        } else {
            LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{blockPos.getX(), blockPos.getY(), blockPos.getZ()});
        }
        return true;
    }

    private EntityType<?> randomEntityId(RandomSource random) {
        return Util.getRandom(MOBS, random);
    }
}

