/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.UnderwaterMagmaConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class UnderwaterMagmaFeature
extends Feature<UnderwaterMagmaConfiguration> {
    public UnderwaterMagmaFeature(Codec<UnderwaterMagmaConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean place(FeaturePlaceContext<UnderwaterMagmaConfiguration> context) {
        Vec3i vec3i;
        WorldGenLevel worldGenLevel = context.level();
        BlockPos blockPos = context.origin();
        UnderwaterMagmaConfiguration underwaterMagmaConfiguration = context.config();
        RandomSource randomSource = context.random();
        OptionalInt optionalInt = UnderwaterMagmaFeature.getFloorY(worldGenLevel, blockPos, underwaterMagmaConfiguration);
        if (optionalInt.isEmpty()) {
            return false;
        }
        BlockPos blockPos2 = blockPos.atY(optionalInt.getAsInt());
        BoundingBox boundingBox = BoundingBox.fromCorners(blockPos2.subtract(vec3i = new Vec3i(underwaterMagmaConfiguration.placementRadiusAroundFloor, underwaterMagmaConfiguration.placementRadiusAroundFloor, underwaterMagmaConfiguration.placementRadiusAroundFloor)), blockPos2.offset(vec3i));
        return BlockPos.betweenClosedStream(boundingBox).filter(pos -> randomSource.nextFloat() < underwaterMagmaConfiguration.placementProbabilityPerValidPosition).filter(pos -> this.isValidPlacement(worldGenLevel, (BlockPos)pos)).mapToInt(pos -> {
            worldGenLevel.setBlock((BlockPos)pos, Blocks.MAGMA_BLOCK.defaultBlockState(), 2);
            return 1;
        }).sum() > 0;
    }

    private static OptionalInt getFloorY(WorldGenLevel world, BlockPos pos, UnderwaterMagmaConfiguration config) {
        Predicate<BlockState> predicate = state -> state.is(Blocks.WATER);
        Predicate<BlockState> predicate2 = state -> !state.is(Blocks.WATER);
        Optional<Column> optional = Column.scan(world, pos, config.floorSearchRange, predicate, predicate2);
        return optional.map(Column::getFloor).orElseGet(OptionalInt::empty);
    }

    private boolean isValidPlacement(WorldGenLevel world, BlockPos pos) {
        if (this.isWaterOrAir(world, pos) || this.isWaterOrAir(world, pos.below())) {
            return false;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!this.isWaterOrAir(world, pos.relative(direction))) continue;
            return false;
        }
        return true;
    }

    private boolean isWaterOrAir(LevelAccessor world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.is(Blocks.WATER) || blockState.isAir();
    }
}

